/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.item.ISpellBonus;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.util.CuriosUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class SpellRecipeUtil {
    public static List<AbstractAugment> getAugments(List<AbstractSpellPart> spell_recipe, int startPosition, @Nullable LivingEntity caster) {
        AbstractSpellPart next_spell;
        ArrayList<AbstractAugment> augments = new ArrayList<AbstractAugment>();
        for (int j = startPosition + 1; j < spell_recipe.size() && (next_spell = spell_recipe.get(j)) instanceof AbstractAugment; ++j) {
            augments.add((AbstractAugment)next_spell);
        }
        if (caster != null) {
            augments.addAll(SpellRecipeUtil.getEquippedAugments(caster));
        }
        return augments;
    }

    public static List<AbstractAugment> getEquippedAugments(@Nonnull LivingEntity caster) {
        ArrayList<AbstractAugment> augments = new ArrayList<AbstractAugment>();
        CuriosUtil.getAllWornItems(caster).ifPresent(e -> {
            for (int i = 0; i < e.getSlots(); ++i) {
                Item item = e.getStackInSlot(i).func_77973_b();
                if (!(item instanceof ISpellBonus)) continue;
                augments.addAll(((ISpellBonus)item).getList(e.getStackInSlot(i)));
            }
        });
        caster.func_184193_aE().forEach(itemStack -> {
            if (itemStack.func_77973_b() instanceof ISpellBonus) {
                augments.addAll(((ISpellBonus)itemStack.func_77973_b()).getList((ItemStack)itemStack));
            }
        });
        return augments;
    }

    public static ArrayList<AbstractSpellPart> getSpellsFromString(String spellString) {
        List<String> spellStrings = Arrays.asList(spellString.split(","));
        ArrayList<AbstractSpellPart> spells = new ArrayList<AbstractSpellPart>();
        spellStrings.forEach(s -> {
            Optional<AbstractSpellPart> spell = ArsNouveauAPI.getInstance().getSpell_map().values().stream().filter(sp -> sp.getTag().equals(s.trim())).findFirst();
            spell.ifPresent(spells::add);
        });
        return spells;
    }

    public static ArrayList<AbstractSpellPart> getSpellsFromTagString(String recipeStr) {
        String[] recipeList;
        ArrayList<AbstractSpellPart> recipe = new ArrayList<AbstractSpellPart>();
        if (recipeStr == null || recipeStr.length() <= 3) {
            return recipe;
        }
        for (String id : recipeList = recipeStr.substring(1, recipeStr.length() - 1).split(",")) {
            if (!ArsNouveauAPI.getInstance().getSpell_map().containsKey(id.trim())) continue;
            recipe.add(ArsNouveauAPI.getInstance().getSpell_map().get(id.trim()));
        }
        return recipe;
    }

    public static String serializeForNBT(List<AbstractSpellPart> abstractSpellPart) {
        ArrayList<String> tags = new ArrayList<String>();
        for (AbstractSpellPart slot : abstractSpellPart) {
            tags.add(slot.tag);
        }
        return ((Object)tags).toString();
    }

    public static String getDisplayString(List<AbstractSpellPart> abstractSpellPart) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < abstractSpellPart.size(); ++i) {
            AbstractSpellPart spellPart = abstractSpellPart.get(i);
            str.append(spellPart.name);
            if (i >= abstractSpellPart.size() - 1) continue;
            str.append(" -> ");
        }
        return str.toString();
    }
}

