/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.google.common.collect.ImmutableList;
import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class SpellUtil {
    public static boolean postEvent(SpellCastEvent e) {
        return MinecraftForge.EVENT_BUS.post((Event)e);
    }

    public static boolean isValidSpell(ArrayList<AbstractSpellPart> recipe) {
        AbstractCastMethod method = null;
        if (recipe == null || recipe.isEmpty() || !(recipe.get(0) instanceof AbstractCastMethod)) {
            return false;
        }
        method = (AbstractCastMethod)recipe.get(0);
        if (recipe.isEmpty() || method == null) {
            return false;
        }
        HashSet<AbstractSpellPart> testSet = new HashSet<AbstractSpellPart>(recipe.size());
        for (AbstractSpellPart part : recipe) {
            if (!(part instanceof AbstractEffect) || testSet.add(part)) continue;
            return false;
        }
        return true;
    }

    public static List<LivingEntity> calcAOEEntities(Entity entity, int range) {
        return entity.func_130014_f_().func_217357_a(LivingEntity.class, new AxisAlignedBB(entity.func_180425_c()).func_186662_g((double)range));
    }

    public static ImmutableList<BlockPos> calcAOEBlocks(LivingEntity caster, BlockPos origin, BlockRayTraceResult mop, int aoeBonus) {
        return SpellUtil.calcAOEBlocks(caster, origin, mop, 1 + aoeBonus, 1 + aoeBonus, 1, -1);
    }

    public static ImmutableList<BlockPos> calcAOEBlocks(LivingEntity caster, BlockPos origin, BlockRayTraceResult mop, int width, int height, int depth, int distance) {
        int z;
        int y;
        int x;
        BlockPos start = origin;
        switch (mop.func_216354_b()) {
            case DOWN: 
            case UP: {
                Vec3i vec = caster.func_174811_aO().func_176730_m();
                x = vec.func_177958_n() * height + vec.func_177952_p() * width;
                y = mop.func_216354_b().func_176743_c().func_179524_a() * -depth;
                z = vec.func_177958_n() * width + vec.func_177952_p() * height;
                start = start.func_177982_a(-x / 2, 0, -z / 2);
                if (x % 2 == 0) {
                    if (x > 0 && mop.func_216347_e().field_72450_a - (double)mop.func_216350_a().func_177958_n() > 0.5) {
                        start = start.func_177982_a(1, 0, 0);
                    } else if (x < 0 && mop.func_216347_e().field_72450_a - (double)mop.func_216350_a().func_177958_n() < 0.5) {
                        start = start.func_177982_a(-1, 0, 0);
                    }
                }
                if (z % 2 != 0) break;
                if (z > 0 && mop.func_216347_e().field_72449_c - (double)mop.func_216350_a().func_177952_p() > 0.5) {
                    start = start.func_177982_a(0, 0, 1);
                    break;
                }
                if (z >= 0 || !(mop.func_216347_e().field_72449_c - (double)mop.func_216350_a().func_177952_p() < 0.5)) break;
                start = start.func_177982_a(0, 0, -1);
                break;
            }
            case NORTH: 
            case SOUTH: {
                x = width;
                y = height;
                z = mop.func_216354_b().func_176743_c().func_179524_a() * -depth;
                start = start.func_177982_a(-x / 2, -y / 2, 0);
                if (x % 2 == 0 && mop.func_216347_e().field_72450_a - (double)mop.func_216350_a().func_177958_n() > 0.5) {
                    start = start.func_177982_a(1, 0, 0);
                }
                if (y % 2 != 0 || !(mop.func_216347_e().field_72448_b - (double)mop.func_216350_a().func_177956_o() > 0.5)) break;
                start = start.func_177982_a(0, 1, 0);
                break;
            }
            case WEST: 
            case EAST: {
                x = mop.func_216354_b().func_176743_c().func_179524_a() * -depth;
                y = height;
                z = width;
                start = start.func_177982_a(0, -y / 2, -z / 2);
                if (y % 2 == 0 && mop.func_216347_e().field_72448_b - (double)mop.func_216350_a().func_177956_o() > 0.5) {
                    start = start.func_177982_a(0, 1, 0);
                }
                if (z % 2 != 0 || !(mop.func_216347_e().field_72449_c - (double)mop.func_216350_a().func_177952_p() > 0.5)) break;
                start = start.func_177982_a(0, 0, 1);
                break;
            }
            default: {
                z = 0;
                y = 0;
                x = 0;
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int xp = start.func_177958_n(); xp != start.func_177958_n() + x; xp += x / MathHelper.func_76130_a((int)x)) {
            for (int yp = start.func_177956_o(); yp != start.func_177956_o() + y; yp += y / MathHelper.func_76130_a((int)y)) {
                for (int zp = start.func_177952_p(); zp != start.func_177952_p() + z; zp += z / MathHelper.func_76130_a((int)z)) {
                    if (xp == origin.func_177958_n() && yp == origin.func_177956_o() && zp == origin.func_177952_p() || distance > 0 && MathHelper.func_76130_a((int)(xp - origin.func_177958_n())) + MathHelper.func_76130_a((int)(yp - origin.func_177956_o())) + MathHelper.func_76130_a((int)(zp - origin.func_177952_p())) > distance) continue;
                    BlockPos pos = new BlockPos(xp, yp, zp);
                    builder.add((Object)pos);
                }
            }
        }
        builder.add((Object)origin);
        return builder.build();
    }
}

