/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client;

import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;

public class RenderUtil {
    private static final ResourceLocation laserBeam = new ResourceLocation("ars_nouveau", "textures/particle/laser.png");
    private static final ResourceLocation laserBeam2 = new ResourceLocation("ars_nouveau", "textures/particle/laser2.png");
    private static final ResourceLocation laserBeamGlow = new ResourceLocation("ars_nouveau", "textures/particle/laser_glow.png");

    public static void drawLasers(RenderWorldLastEvent event, Vec3d from, Vec3d to, double xOffset, double yOffset, double zOffset, float r, float g, float b, float thickness, PlayerEntity player, float ticks, float speedModifier) {
        Hand activeHand = Hand.MAIN_HAND;
        double distance = from.func_178788_d(to).func_72433_c();
        long gameTime = ClientInfo.ticksInGame;
        double v = (float)gameTime * speedModifier;
        float additiveThickness = thickness * 3.5f * RenderUtil.calculateLaserFlickerModifier(gameTime);
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        Vec3d view = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        MatrixStack matrix = event.getMatrixStack();
        matrix.func_227861_a_(view.func_82615_a(), view.func_82617_b(), view.func_82616_c());
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)matrix.func_227866_c_().func_227870_a_());
        RenderSystem.enableColorMaterial();
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.enableTexture();
        RenderSystem.rotatef((float)MathHelper.func_219799_g((float)ticks, (float)(-player.field_70177_z), (float)(-player.field_70126_B)), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.rotatef((float)MathHelper.func_219799_g((float)ticks, (float)player.field_70125_A, (float)player.field_70127_C), (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)0.7f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(laserBeamGlow);
        RenderUtil.drawBeam(from, to, additiveThickness, activeHand, distance, wr, 0.5, 1.0, ticks);
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(laserBeam2);
        RenderUtil.drawBeam(from, to, thickness, activeHand, distance, wr, v, v + distance * 1.5, ticks);
        RenderSystem.color4f((float)0.39215687f, (float)0.39215687f, (float)0.39215687f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(laserBeam);
        RenderUtil.drawBeam(from, to, thickness / 2.0f, activeHand, distance, wr, v, v + distance * 1.5, ticks);
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.popMatrix();
    }

    private static float calculateLaserFlickerModifier(long gameTime) {
        return 0.9f + 0.1f * MathHelper.func_76126_a((float)((float)gameTime * 0.99f)) * MathHelper.func_76126_a((float)((float)gameTime * 0.3f)) * MathHelper.func_76126_a((float)((float)gameTime * 0.1f));
    }

    private static void drawBeam(Vec3d from, Vec3d to, float thickness, Hand hand, double distance, BufferBuilder wr, double v1, double v2, float ticks) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        float startXOffset = (float)from.field_72450_a;
        float startYOffset = (float)from.field_72448_b;
        float startZOffset = (float)from.field_72449_c;
        float xOffset = 0.0f;
        float yOffset = 0.0f;
        float zOffset = 0.0f;
        float f = (float)MathHelper.func_219803_d((double)ticks, (double)from.field_72450_a, (double)to.field_72450_a);
        float f1 = (float)MathHelper.func_219803_d((double)ticks, (double)from.field_72448_b, (double)to.field_72448_b);
        startXOffset += f1;
        startYOffset += f;
        if (Minecraft.func_71410_x().field_71474_y.field_186715_A != HandSide.RIGHT) {
            hand = hand == Hand.MAIN_HAND ? Hand.OFF_HAND : Hand.MAIN_HAND;
        }
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_225582_a_((double)startXOffset, (double)(-thickness + startYOffset), (double)startZOffset).func_225583_a_(1.0f, (float)v1).func_181675_d();
        wr.func_225582_a_((double)xOffset, (double)(-thickness + yOffset), distance + (double)zOffset).func_225583_a_(1.0f, (float)v2).func_181675_d();
        wr.func_225582_a_((double)xOffset, (double)(thickness + yOffset), distance + (double)zOffset).func_225583_a_(0.0f, (float)v2).func_181675_d();
        wr.func_225582_a_((double)startXOffset, (double)(thickness + startYOffset), (double)startZOffset).func_225583_a_(0.0f, (float)v1).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }
}

