/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.util.SpellRecipeUtil;
import com.hollingsworth.arsnouveau.client.gui.ModdedScreen;
import com.hollingsworth.arsnouveau.client.gui.buttons.CraftingButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.GlyphButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiImageButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiSpellSlot;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateSpellbook;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.lwjgl.opengl.GL11;
import vazkii.patchouli.api.PatchouliAPI;

public class GuiSpellBook
extends ModdedScreen {
    private final int FULL_WIDTH = 272;
    private final int FULL_HEIGHT = 180;
    private static ResourceLocation background = new ResourceLocation("ars_nouveau", "textures/gui/spell_book.png");
    public int numLinks = 10;
    public int bookLeft;
    public int bookTop;
    public int bookRight;
    public SpellBook spellBook;
    public ArsNouveauAPI api;
    private int offsetFromScreenLeft;
    private int offsetFromScreenTop;
    private int selected_cast_slot;
    public TextFieldWidget spell_name;
    public CompoundNBT spell_book_tag;
    public GuiSpellSlot selected_slot;
    public int max_spell_tier;
    List<CraftingButton> craftingCells;
    public ArrayList<AbstractSpellPart> unlockedSpells;

    public GuiSpellBook(ArsNouveauAPI api, CompoundNBT tag, int tier, String unlockedSpells) {
        super((ITextComponent)new StringTextComponent(""));
        this.api = api;
        this.selected_cast_slot = 1;
        this.craftingCells = new ArrayList<CraftingButton>();
        this.max_spell_tier = tier;
        this.spell_book_tag = tag;
        this.unlockedSpells = SpellRecipeUtil.getSpellsFromString(unlockedSpells);
    }

    @Override
    public void init() {
        int i;
        super.init();
        this.minecraft.field_195559_v.func_197967_a(true);
        this.offsetFromScreenLeft = (this.width - 272) / 2;
        this.offsetFromScreenTop = (this.height - 180) / 2;
        this.bookLeft = this.width / 2 - 136;
        this.bookTop = this.height / 2 - 90;
        this.bookRight = this.width / 2 + 136;
        int selected_slot_ind = SpellBook.getMode(this.spell_book_tag);
        if (selected_slot_ind == 0) {
            selected_slot_ind = 1;
        }
        int bookBottom = this.height / 2 + 90;
        for (i = 0; i < this.numLinks; ++i) {
            Object icon = null;
            String spell_id = "";
            int offset = i >= 5 ? 5 : 0;
            CraftingButton cell = new CraftingButton(this, this.bookLeft + 14 + 24 * i + offset, this.bookTop + 180 - 50, i, this::onCraftingSlotClick);
            this.addButton((Widget)cell);
            this.craftingCells.add(cell);
        }
        this.updateCraftingSlots(selected_slot_ind);
        this.addSpellParts();
        this.addButton((Widget)new GuiImageButton(this.bookRight - 70, bookBottom - 28, 0, 0, 46, 18, 46, 18, "textures/gui/create_button.png", this::onCreateClick));
        this.spell_name = new TextFieldWidget(this.minecraft.field_71466_p, this.bookLeft + 16, this.bookTop + 180 - 25, 115, 12, null, "Spell Name");
        this.spell_name.func_146180_a(SpellBook.getSpellName(this.spell_book_tag, SpellBook.getMode(this.spell_book_tag)));
        if (this.spell_name.func_146179_b().isEmpty()) {
            this.spell_name.func_195612_c("My Spell");
        }
        this.addButton((Widget)this.spell_name);
        for (i = 1; i <= 10; ++i) {
            GuiSpellSlot slot = new GuiSpellSlot(this, this.bookLeft + 261, this.bookTop - 3 + 15 * i, i);
            if (i == selected_slot_ind) {
                this.selected_slot = slot;
                this.selected_cast_slot = i;
                slot.isSelected = true;
            }
            this.addButton((Widget)slot);
        }
        this.addButton((Widget)new GuiImageButton(this.bookLeft - 15, this.bookTop, 0, 0, 16, 16, 16, 16, "textures/items/worn_notebook.png", this::onDocumentationClick));
    }

    public void addSpellParts() {
        Set<String> keys = this.api.getSpell_map().keySet();
        Collections.sort(this.unlockedSpells);
        int numCast = 0;
        int numEffect = 0;
        int numAugment = 0;
        for (AbstractSpellPart key : this.unlockedSpells) {
            GlyphButton cell;
            int yOffset;
            int xOffset;
            AbstractSpellPart spell = this.api.getSpell_map().get(key.tag);
            if (spell.getTier().ordinal() > this.max_spell_tier) continue;
            if (spell instanceof AbstractCastMethod) {
                xOffset = 18 * (numCast % 6);
                yOffset = numCast / 6 * 20;
                cell = new GlyphButton(this, this.bookLeft + 15 + xOffset, this.bookTop + 20 + yOffset, false, spell.getIcon(), spell.tag);
                ++numCast;
            } else if (spell instanceof AbstractEffect) {
                xOffset = 20 * (numEffect % 6);
                yOffset = numEffect / 6 * 18;
                cell = new GlyphButton(this, this.bookLeft + 140 + xOffset, this.bookTop + 20 + yOffset, false, spell.getIcon(), spell.tag);
                ++numEffect;
            } else {
                xOffset = 20 * (numAugment % 6);
                yOffset = numAugment / 6 * 20;
                cell = new GlyphButton(this, this.bookLeft + 15 + xOffset, this.bookTop + 70 + yOffset, false, spell.getIcon(), spell.tag);
                ++numAugment;
            }
            this.addButton((Widget)cell);
        }
    }

    public void onDocumentationClick(Button button) {
        PatchouliAPI.instance.openBookGUI(Registry.field_212630_s.func_177774_c((Object)ItemsRegistry.wornNotebook));
    }

    public void onCraftingSlotClick(Button button) {
        ((CraftingButton)button).spellTag = "";
        ((CraftingButton)button).resourceIcon = "";
    }

    public void onGlyphClick(Button button) {
        GlyphButton button1 = (GlyphButton)button;
        for (CraftingButton b : this.craftingCells) {
            if (!b.resourceIcon.equals("")) continue;
            b.resourceIcon = button1.resourceIcon;
            b.spellTag = button1.spell_id;
            return;
        }
    }

    public void onSlotChange(Button button) {
        this.selected_slot.isSelected = false;
        this.selected_slot = (GuiSpellSlot)button;
        this.selected_slot.isSelected = true;
        this.selected_cast_slot = this.selected_slot.slotNum;
        this.updateCraftingSlots(this.selected_cast_slot);
        this.spell_name.func_146180_a(SpellBook.getSpellName(this.spell_book_tag, this.selected_cast_slot));
    }

    public void updateCraftingSlots(int bookSlot) {
        ArrayList<AbstractSpellPart> spell_recipe = this.spell_book_tag != null ? SpellBook.getRecipeFromTag(this.spell_book_tag, bookSlot) : null;
        for (int i = 0; i < this.craftingCells.size(); ++i) {
            CraftingButton slot = this.craftingCells.get(i);
            slot.spellTag = "";
            slot.resourceIcon = "";
            if (spell_recipe == null || i >= spell_recipe.size()) continue;
            slot.spellTag = spell_recipe.get(i).getTag();
            slot.resourceIcon = spell_recipe.get(i).getIcon();
        }
    }

    public void onCreateClick(Button button) {
        ArrayList<String> ids = new ArrayList<String>();
        for (CraftingButton slot : this.craftingCells) {
            ids.add(slot.spellTag);
        }
        Networking.INSTANCE.sendToServer((Object)new PacketUpdateSpellbook(((Object)ids).toString(), this.selected_cast_slot, this.spell_name.func_146179_b()));
    }

    public static void open(ArsNouveauAPI api, CompoundNBT spell_book_tag, int tier, String unlockedSpells) {
        Minecraft.func_71410_x().func_147108_a((Screen)new GuiSpellBook(api, spell_book_tag, tier, unlockedSpells));
    }

    final void drawScreenAfterScale(int mouseX, int mouseY, float partialTicks) {
        this.resetTooltip();
        this.renderBackground();
        GlStateManager.func_227626_N_();
        GlStateManager.func_227688_c_((float)this.bookLeft, (float)this.bookTop, (float)0.0f);
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBackgroundElements(mouseX, mouseY, partialTicks);
        this.drawForegroundElements(mouseX, mouseY, partialTicks);
        GlStateManager.func_227627_O_();
        super.render(mouseX, mouseY, partialTicks);
        this.drawTooltip(mouseX, mouseY);
    }

    final void drawBackgroundElements(int mouseX, int mouseY, float partialTicks) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(background);
        int png_width = 272;
        int png_height = 180;
        GuiSpellBook.drawFromTexture(background, 0, 0, 0, 0, 272, 180, png_width, png_height);
        this.minecraft.field_71466_p.func_78279_b("Form", 15, 10, 116, 0);
        this.minecraft.field_71466_p.func_78279_b("Effect", 140, 10, 116, 0);
        this.minecraft.field_71466_p.func_78279_b("Augment", 15, 60, 116, 0);
        this.minecraft.field_71466_p.func_78279_b("Create", 208, 157, 116, 0);
    }

    public static void drawFromTexture(ResourceLocation resourceLocation, int x, int y, int u, int v, int w, int h) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(resourceLocation);
        GuiSpellBook.blit((int)x, (int)y, (float)u, (float)v, (int)w, (int)h, (int)w, (int)h);
    }

    public static void drawFromTexture(ResourceLocation resourceLocation, int x, int y, int u, int v, int w, int h, int fileWidth, int fileHeight) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(resourceLocation);
        GuiSpellBook.blit((int)x, (int)y, (float)u, (float)v, (int)w, (int)h, (int)fileWidth, (int)fileHeight);
    }

    private void drawForegroundElements(int mouseX, int mouseY, float partialTicks) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.spell_name.func_146179_b().isEmpty()) {
            this.spell_name.func_195612_c("My Spell Name");
        } else {
            this.spell_name.func_195612_c("");
        }
        GlStateManager.func_227626_N_();
        if (this.scaleFactor != 1.0f) {
            GlStateManager.func_227672_b_((float)this.scaleFactor, (float)this.scaleFactor, (float)this.scaleFactor);
            mouseX = (int)((float)mouseX / this.scaleFactor);
            mouseY = (int)((float)mouseY / this.scaleFactor);
        }
        this.drawScreenAfterScale(mouseX, mouseY, partialTicks);
        GlStateManager.func_227627_O_();
    }
}

