/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.buttons;

import com.hollingsworth.arsnouveau.client.gui.GuiSpellBook;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GlyphButton
extends Button {
    public boolean isCraftingSlot;
    public String resourceIcon;
    public String spell_id;
    private int id;
    public String tooltip = "tooltip";
    GuiSpellBook parent;

    public GlyphButton(GuiSpellBook parent, int x, int y, boolean isCraftingSlot, String resource_image, String spell_id) {
        super(x, y, 16, 16, "", parent::onGlyphClick);
        this.parent = parent;
        this.x = x;
        this.y = y;
        this.width = 16;
        this.height = 16;
        this.isCraftingSlot = isCraftingSlot;
        this.resourceIcon = resource_image;
        this.spell_id = spell_id;
        this.id = 0;
    }

    public GlyphButton(GuiSpellBook parent, int x, int y, boolean isCraftingSlot, String resource_image, String spell_id, Integer id) {
        this(parent, x, y, isCraftingSlot, resource_image, spell_id);
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public boolean isHovered() {
        return super.isHovered();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            if (this.resourceIcon != null && !this.resourceIcon.equals("")) {
                RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
                GuiSpellBook.drawFromTexture(new ResourceLocation("ars_nouveau", "textures/items/" + this.resourceIcon), this.x, this.y, 0, 0, 16, 16, 16, 16);
            }
            if (this.parent.isMouseInRelativeRange(mouseX, mouseY, this.x, this.y, this.width, this.height) && this.parent.api.getSpell_map().containsKey(this.spell_id)) {
                ArrayList<String> test = new ArrayList<String>();
                test.add(this.parent.api.getSpell_map().get((Object)this.spell_id).name);
                this.parent.tooltip = test;
            }
        }
    }
}

