/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.hollingsworth.arsnouveau.api.recipe.GlyphPressRecipe;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.config.Constants;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class GlyphPressRecipeCategory
implements IRecipeCategory<GlyphPressRecipe> {
    public IDrawable background;
    public IDrawable icon;
    IGuiHelper helper;
    public static final ResourceLocation UID = new ResourceLocation("ars_nouveau", "glyph_press");
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public GlyphPressRecipeCategory(final IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createBlankDrawable(60, 30);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((IItemProvider)BlockRegistry.GLYPH_PRESS_BLOCK));
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return helper.drawableBuilder(Constants.RECIPE_GUI_VANILLA, 82, 128, 24, 17).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends GlyphPressRecipe> getRecipeClass() {
        return GlyphPressRecipe.class;
    }

    public String getTitle() {
        return "Glyph Press";
    }

    public IDrawable getBackground() {
        return this.helper.createBlankDrawable(80, 30);
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(GlyphPressRecipe recipe, double mouseX, double mouseY) {
        IDrawableAnimated arrow = (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)40);
        arrow.draw(38, 6);
    }

    public void setIngredients(GlyphPressRecipe glyphPressRecipe, IIngredients iIngredients) {
        ItemStack clay = glyphPressRecipe.tier == ISpellTier.Tier.ONE ? new ItemStack((IItemProvider)ItemsRegistry.magicClay) : (glyphPressRecipe.tier == ISpellTier.Tier.TWO ? new ItemStack((IItemProvider)ItemsRegistry.marvelousClay) : new ItemStack((IItemProvider)ItemsRegistry.mythicalClay));
        ArrayList<List<ItemStack>> itemStacks = new ArrayList<List<ItemStack>>();
        itemStacks.add(Collections.singletonList(clay));
        itemStacks.add(Collections.singletonList(glyphPressRecipe.reagent));
        iIngredients.setInputLists(VanillaTypes.ITEM, itemStacks);
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)glyphPressRecipe.output);
    }

    public void setRecipe(IRecipeLayout recipeLayout, GlyphPressRecipe o, IIngredients ingredients) {
        int index = 0;
        recipeLayout.getItemStacks().init(index, true, 0, 4);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        recipeLayout.getItemStacks().init(++index, true, 16, 4);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getInputs(VanillaTypes.ITEM).get(1));
        recipeLayout.getItemStacks().init(++index, true, 64, 4);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }
}

