/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle;

import com.hollingsworth.arsnouveau.client.particle.ArcParticleTypeData;
import com.hollingsworth.arsnouveau.client.particle.RenderTypes;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleArc
extends SpriteTexturedParticle {
    public static final String NAME = "arc";
    float forwardFactor;
    Entity targetEntity;
    Entity sourceEntity;
    boolean ignoreAge = true;
    double deviation;
    float speed;
    float field_187134_n;
    boolean extendToTarget;
    float extensionProgress;
    Vec3d targetPoint;
    Vec3d currentTargetPoint;
    Vec3d sourcePoint;
    boolean hadTarget = false;
    boolean hadSource = false;

    private ParticleArc(World worldIn, Vec3d coord, IAnimatedSprite sprite, Vec3d sourcePoint, Vec3d targetPoint) {
        super(worldIn, coord.func_82615_a(), coord.func_82617_b(), coord.func_82616_c());
        this.sourcePoint = sourcePoint;
        this.targetPoint = targetPoint;
        this.currentTargetPoint = this.copyVec(targetPoint);
        this.deviation = 1.0;
        this.speed = 0.01f;
        this.field_187134_n = 0.05f;
        this.field_70547_e = 100;
        this.forwardFactor = 0.0f;
        this.func_217568_a(sprite);
    }

    protected ParticleArc(World p_i50998_1_, double p_i50998_2_, double p_i50998_4_, double p_i50998_6_) {
        super(p_i50998_1_, p_i50998_2_, p_i50998_4_, p_i50998_6_);
    }

    public ParticleArc(World world, double x, double y, double z, double targetX, double targetY, double targetZ, String IIconName) {
        super(world, x, y, z);
        this.targetPoint = new Vec3d(targetX, targetY, targetZ);
        this.currentTargetPoint = this.copyVec(this.targetPoint);
        this.sourcePoint = new Vec3d(x, y, z);
        this.deviation = 1.0;
        this.speed = 0.01f;
        this.field_187134_n = 0.05f;
        this.field_70547_e = 100;
        this.forwardFactor = 0.0f;
    }

    public void func_225606_a_(IVertexBuilder p_225606_1_, ActiveRenderInfo p_225606_2_, float partialTicks) {
        super.func_225606_a_(p_225606_1_, p_225606_2_, partialTicks);
        try {
            this.drawArcingLine(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks, this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks, this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks, this.currentTargetPoint.field_72450_a, this.currentTargetPoint.field_72448_b, this.currentTargetPoint.field_72449_c, partialTicks, this.speed, this.deviation);
        }
        catch (Throwable e) {
            System.out.println(e);
        }
    }

    public void func_189213_a() {
        super.func_189213_a();
        ++this.field_70546_d;
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d >= this.field_70547_e) {
            this.func_187112_i();
            return;
        }
        if (this.targetEntity != null) {
            if (this.ignoreAge) {
                this.field_70546_d = 0;
            }
            if (!this.targetEntity.func_70089_S()) {
                this.func_187112_i();
                return;
            }
            this.targetPoint = new Vec3d(this.targetEntity.func_226277_ct_(), this.targetEntity.func_226278_cu_() + (double)this.targetEntity.func_70047_e() - (double)(this.targetEntity.func_213302_cg() * 0.2f), this.targetEntity.func_226281_cx_());
            this.currentTargetPoint = new Vec3d(this.targetPoint.field_72450_a, this.targetPoint.field_72448_b, this.targetPoint.field_72449_c);
        } else if (this.hadTarget) {
            this.func_187112_i();
            return;
        }
        if (this.sourceEntity != null) {
            if (this.ignoreAge) {
                this.field_70546_d = 0;
            }
            if (!this.sourceEntity.func_70089_S()) {
                this.func_187112_i();
                return;
            }
            this.sourcePoint = new Vec3d(this.sourceEntity.func_226277_ct_(), this.sourceEntity.func_226278_cu_() + (double)this.sourceEntity.func_70047_e() - (double)(this.sourceEntity.func_213302_cg() * 0.2f), this.sourceEntity.func_226281_cx_());
        } else if (this.hadSource) {
            this.func_187112_i();
            return;
        }
        if (this.extendToTarget && this.extensionProgress < 1.0f) {
            this.extensionProgress = (float)((double)this.extensionProgress + 0.08);
            Vec3d delta = this.copyVec(this.targetPoint).func_178788_d(this.sourcePoint);
            delta.func_186678_a((double)this.extensionProgress);
            this.currentTargetPoint = delta.func_178787_e(this.sourcePoint);
        }
    }

    public Vec3d copyVec(Vec3d vec3d) {
        return new Vec3d(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    public IParticleRenderType func_217558_b() {
        return RenderTypes.AN_RENDER;
    }

    public void drawArcingLine(double srcX, double srcY, double srcZ, double dstX, double dstY, double dstZ, float partialTicks, float speed, double distance) {
        int fxQuality = 10;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        double interpolatedX = player.field_70169_q + (player.func_226277_ct_() - player.field_70169_q) * (double)partialTicks;
        double interpolatedY = player.field_70167_r + (player.func_226278_cu_() - player.field_70167_r) * (double)partialTicks;
        double interpolatedZ = player.field_70166_s + (player.func_226281_cx_() - player.field_70166_s) * (double)partialTicks;
        Tessellator tessellator = Tessellator.func_178181_a();
        double deltaX = srcX - dstX;
        double deltaY = srcY - dstY;
        double deltaZ = srcZ - dstZ;
        float time = System.nanoTime() / 10000000L;
        float dist = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
        float blocks = Math.round(dist);
        float length = blocks * ((float)fxQuality / 2.0f);
        float vMin = 0.0f;
        float VMax = 1.0f;
        double wGain = (double)(this.field_187134_n * 3.0f) / ((double)length * distance);
        float curWidth = this.field_187134_n * 3.0f;
        int i = 0;
        while ((double)i <= (double)length * distance) {
            float lengthFactor = (float)i / length;
            float f3 = 1.0f - Math.abs((float)i - length / 2.0f) / (length / 2.0f);
            float dx = (float)(deltaX + (double)(MathHelper.func_76126_a((float)((float)((srcX % 16.0 + (double)(dist * (1.0f - lengthFactor) * (float)fxQuality / 2.0f) - (double)(time % 32767.0f / 5.0f)) / 4.0))) * 0.5f * f3));
            float dy = (float)(deltaY + (double)(MathHelper.func_76126_a((float)((float)((srcY % 16.0 + (double)(dist * (1.0f - lengthFactor) * (float)fxQuality / 2.0f) - (double)(time % 32767.0f / 5.0f)) / 3.0))) * 0.5f * f3));
            float dz = (float)(deltaZ + (double)(MathHelper.func_76126_a((float)((float)((srcZ % 16.0 + (double)(dist * (1.0f - lengthFactor) * (float)fxQuality / 2.0f) - (double)(time % 32767.0f / 5.0f)) / 2.0))) * 0.5f * f3));
            System.out.println(dy * lengthFactor);
            float u = (1.0f - lengthFactor) * dist - time * speed;
            curWidth = (float)((double)curWidth - wGain);
            ++i;
        }
        this.forwardFactor = (this.forwardFactor + 0.01f) % 1.0f;
    }

    public static IParticleData createData(Vec3d source, Vec3d target) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Factory
    implements IParticleFactory<ArcParticleTypeData> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite sprite) {
            this.spriteSet = sprite;
        }

        public Particle makeParticle(ArcParticleTypeData data, World worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ParticleArc(worldIn, new Vec3d(x, y, z), this.spriteSet, data.source, data.target);
        }
    }
}

