/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle;

public class ParticleColor {
    private final float r;
    private final float g;
    private final float b;
    private final int color;
    private final float alpha;

    public ParticleColor(int r, int g, int b) {
        this.r = (float)r / 255.0f;
        this.g = (float)g / 255.0f;
        this.b = (float)b / 255.0f;
        this.color = r << 16 | g << 8 | b;
        this.alpha = 1.0f;
    }

    public ParticleColor(int r, int g, int b, float a) {
        this.r = (float)r / 255.0f;
        this.g = (float)g / 255.0f;
        this.b = (float)b / 255.0f;
        this.color = r << 16 | g << 8 | b;
        this.alpha = a;
    }

    public float getRed() {
        return this.r;
    }

    public float getGreen() {
        return this.g;
    }

    public float getBlue() {
        return this.b;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public int getColor() {
        return this.color;
    }

    public String serialize() {
        return "" + this.r + "," + this.g + "," + this.b + "," + this.alpha;
    }

    public static ParticleColor deserialize(String string) {
        String[] arr = string.split(",");
        return new ParticleColor(Integer.parseInt(arr[0].trim()), Integer.parseInt(arr[1].trim()), Integer.parseInt(arr[2].trim()), Float.parseFloat(arr[3].trim()));
    }
}

