/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ParticleUtil {
    public static Random r = new Random();

    public static double inRange(double min, double max) {
        return ThreadLocalRandom.current().nextDouble(min, max);
    }

    public static double getCenterOfBlock(double a) {
        return a + 0.5;
    }

    public static Vec3d pointInSphere(BlockPos pos) {
        double u = Math.random();
        double v = Math.random();
        double theta = u * 2.0 * Math.PI;
        double phi = Math.acos(2.0 * v - 1.0);
        double r = Math.cbrt(Math.random());
        double sinTheta = Math.sin(theta);
        double cosTheta = Math.cos(theta);
        double sinPhi = Math.sin(phi);
        double cosPhi = Math.cos(phi);
        double x = r * sinPhi * cosTheta;
        double y = r * sinPhi * sinTheta;
        double z = r * cosPhi;
        return new Vec3d(x, y, z);
    }

    public static void beam(BlockPos toThisBlock, BlockPos fromThisBlock, World world) {
        Random rand = new Random();
        double x2 = ParticleUtil.getCenterOfBlock(toThisBlock.func_177958_n());
        double z2 = ParticleUtil.getCenterOfBlock(toThisBlock.func_177952_p());
        double y2 = ParticleUtil.getCenterOfBlock(toThisBlock.func_177956_o());
        double x1 = ParticleUtil.getCenterOfBlock(fromThisBlock.func_177958_n());
        double z1 = ParticleUtil.getCenterOfBlock(fromThisBlock.func_177952_p());
        double y1 = ParticleUtil.getCenterOfBlock(fromThisBlock.func_177956_o());
        double d5 = 1.2;
        double d0 = x2 - x1;
        double y = toThisBlock.func_177956_o() - fromThisBlock.func_177956_o();
        double d1 = y2 - y1;
        double d2 = z2 - z1;
        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        d0 /= d3;
        d1 /= d3;
        d2 /= d3;
        double d4 = rand.nextDouble();
        while (d4 + 0.65 < d3) {
            d4 += 1.8 - d5 + rand.nextDouble() * (1.5 - d5);
            if (world.field_72995_K) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197623_p, x1 + d0 * d4, y1 + d1 * d4, z1 + d2 * d4, 0.0, 0.0, 0.0);
            }
            if (!(world instanceof ServerWorld)) continue;
            ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197607_R, x1 + d0 * d4, y1 + d1 * d4, z1 + d2 * d4, rand.nextInt(4), 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnPoof(ServerWorld world, BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + 1.2;
            double d2 = (double)pos.func_177952_p() + 0.5;
            world.func_195598_a((IParticleData)ParticleTypes.field_197624_q, d0, d1, d2, 2, ((double)(world.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(world.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(world.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0, (double)0.1f);
        }
    }

    public static void blur(BlockPos pos, World world) {
        double x = ParticleUtil.getCenterOfBlock(pos.func_177958_n());
        double y = ParticleUtil.getCenterOfBlock(pos.func_177956_o()) + 0.5;
        double z = ParticleUtil.getCenterOfBlock(pos.func_177952_p());
        Random rand = world.field_73012_v;
        float scale = 0.05f;
        float red = rand.nextFloat() * 0.03f + 0.5f;
        float green = rand.nextFloat() * 0.03f + (rand.nextBoolean() ? 0.5f : 0.3f);
        float blue = rand.nextFloat() * 0.05f;
        float ageMultiplier = (float)(rand.nextDouble() * 2.5 + 10.0);
    }
}

