/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle.engine;

import com.hollingsworth.arsnouveau.client.particle.engine.TimedEffect;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class ParticleEngine {
    List<TimedEffect> effects = new ArrayList<TimedEffect>();
    List<TimedEffect> scheduled = new ArrayList<TimedEffect>();
    private static ParticleEngine particleEngine;

    public void tick() {
        if (!this.scheduled.isEmpty()) {
            if (this.effects == null) {
                this.effects = new ArrayList<TimedEffect>();
            }
            this.effects.addAll(this.scheduled);
            System.out.println("adding effect");
            this.scheduled = new ArrayList<TimedEffect>();
        }
        if (this.effects.isEmpty()) {
            return;
        }
        ListIterator<TimedEffect> effectListIterator = this.effects.listIterator();
        ArrayList<TimedEffect> stale = new ArrayList<TimedEffect>();
        for (TimedEffect effect1 : this.effects) {
            if (effect1.isDone) {
                stale.add(effect1);
                continue;
            }
            effect1.tick();
        }
        for (TimedEffect effect : stale) {
            this.effects.remove(effect);
        }
    }

    public void addEffect(TimedEffect effect) {
        this.effects.add(effect);
    }

    public void scheduleEffect(TimedEffect effect) {
        this.scheduled.add(effect);
    }

    public static ParticleEngine getInstance() {
        if (particleEngine == null) {
            particleEngine = new ParticleEngine();
        }
        return particleEngine;
    }

    private ParticleEngine() {
    }
}

