/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleSparkleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.client.renderer.entity.SylphModel;
import com.hollingsworth.arsnouveau.common.entity.EntitySylph;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class SylphRenderer
extends MobRenderer<EntitySylph, SylphModel> {
    private static final ResourceLocation WILD_TEXTURE = new ResourceLocation("ars_nouveau", "textures/entity/sylph.png");
    private static SylphModel model = new SylphModel();

    public SylphRenderer(EntityRendererManager manager) {
        super(manager, (EntityModel)new SylphModel(), 0.2f);
    }

    public SylphRenderer(EntityRendererManager renderManagerIn, SylphModel entityModelIn, float shadowSizeIn) {
        super(renderManagerIn, (EntityModel)entityModelIn, shadowSizeIn);
    }

    public void render(EntitySylph entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        World world = entityIn.func_130014_f_();
        Random rand = ParticleUtil.r;
        Vec3d particlePos = entityIn.func_213303_ch();
        float offsetY = ((SylphModel)this.func_217764_d()).sylph.positionOffsetY / 9.0f;
        float roteAngle = ((SylphModel)this.func_217764_d()).propellers.field_78796_g / 4.0f;
        if (rand.nextInt(5) == 0) {
            for (int i = 0; i < 5; ++i) {
                world.func_195594_a(ParticleSparkleData.createData(new ParticleColor(52, 255, 36), 0.05f, 60), particlePos.func_82615_a() + Math.cos(roteAngle) / 2.0, particlePos.func_82617_b() + 0.5 + (double)offsetY, particlePos.func_82616_c() + Math.sin(roteAngle) / 2.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public ResourceLocation getEntityTexture(EntitySylph entity) {
        return WILD_TEXTURE;
    }
}

