/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.tile;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleLineData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.client.renderer.tile.CrystallizerModel;
import com.hollingsworth.arsnouveau.common.block.tile.CrystallizerTile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class CrystallizerRenderer
extends TileEntityRenderer<CrystallizerTile> {
    public static final ResourceLocation texture = new ResourceLocation("ars_nouveau:textures/blocks/crystallizer_final.png");
    public final CrystallizerModel model = new CrystallizerModel();

    public CrystallizerRenderer(TileEntityRendererDispatcher manager) {
        super(manager);
    }

    public void render(CrystallizerTile crystallizerTile, float f, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay) {
        float scaleAge;
        World world = crystallizerTile.func_145831_w();
        BlockPos pos = crystallizerTile.func_174877_v();
        IVertexBuilder buffer = buffers.getBuffer(this.model.func_228282_a_(texture));
        double x = crystallizerTile.func_174877_v().func_177958_n();
        double y = crystallizerTile.func_174877_v().func_177956_o();
        double z = crystallizerTile.func_174877_v().func_177952_p();
        ms.func_227860_a_();
        ms.func_227861_a_(0.5, -0.5, 0.5);
        this.model.render(ms, buffer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        boolean draining = crystallizerTile.draining;
        int baseAge = draining ? 20 : 40;
        int randBound = draining ? 3 : 6;
        int numParticles = draining ? 2 : 1;
        float f2 = scaleAge = draining ? (float)ParticleUtil.inRange(0.1, 0.2) : (float)ParticleUtil.inRange(0.05, 0.15);
        if (world.field_73012_v.nextInt(randBound) == 0) {
            for (int i = 0; i < numParticles; ++i) {
                Vec3d particlePos = new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5);
                particlePos = particlePos.func_178787_e(ParticleUtil.pointInSphere(null));
                world.func_195594_a(ParticleLineData.createData(new ParticleColor(255, 25, 180), scaleAge, baseAge + world.field_73012_v.nextInt(20)), particlePos.func_82615_a(), particlePos.func_82617_b(), particlePos.func_82616_c(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            }
        }
        if (crystallizerTile.stack == null) {
            return;
        }
        if (crystallizerTile.entity == null || !ItemStack.func_77989_b((ItemStack)crystallizerTile.entity.func_92059_d(), (ItemStack)crystallizerTile.stack)) {
            crystallizerTile.entity = new ItemEntity(crystallizerTile.func_145831_w(), x, y, z, crystallizerTile.stack);
        }
        crystallizerTile.entity.func_70107_b(x, y + 1.0, z);
        ItemEntity entityItem = crystallizerTile.entity;
        ms.func_227865_b_();
        ms.func_227860_a_();
        RenderSystem.enableLighting();
        ms.func_227862_a_(0.5f, 0.5f, 0.5f);
        ms.func_227861_a_(1.0, 1.0, 1.0);
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(entityItem.func_92059_d(), ItemCameraTransforms.TransformType.FIXED, 0xF000F0, overlay, ms, buffers);
        ms.func_227865_b_();
    }

    public static class ISRender
    extends ItemStackTileEntityRenderer {
        public final CrystallizerModel model = new CrystallizerModel();

        public void func_228364_a_(ItemStack p_228364_1_, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay) {
            ms.func_227860_a_();
            ms.func_227861_a_(0.75, -0.35, 0.2);
            ms.func_227862_a_(0.6f, 0.6f, 0.6f);
            IVertexBuilder buffer = buffers.getBuffer(this.model.func_228282_a_(texture));
            this.model.render(ms, buffer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            ms.func_227865_b_();
        }
    }
}

