/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.tile;

import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleLineData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.client.renderer.tile.EnchantingApparatusModel;
import com.hollingsworth.arsnouveau.common.block.tile.EnchantingApparatusTile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class EnchantingApparatusRenderer
extends TileEntityRenderer<EnchantingApparatusTile> {
    public static final EnchantingApparatusModel model = new EnchantingApparatusModel();
    public static final ResourceLocation texture = new ResourceLocation("ars_nouveau:textures/entity/enchanting_apparatus.png");

    public EnchantingApparatusRenderer(TileEntityRendererDispatcher p_i226006_1_) {
        super(p_i226006_1_);
    }

    public void render(EnchantingApparatusTile tileEntityIn, float v, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int lightIn, int overlayIn) {
        double x = tileEntityIn.func_174877_v().func_177958_n();
        double y = tileEntityIn.func_174877_v().func_177956_o();
        double z = tileEntityIn.func_174877_v().func_177952_p();
        if (tileEntityIn.catalystItem == null) {
            return;
        }
        if (tileEntityIn.entity == null || !ItemStack.func_77989_b((ItemStack)tileEntityIn.entity.func_92059_d(), (ItemStack)tileEntityIn.catalystItem)) {
            tileEntityIn.entity = new ItemEntity(tileEntityIn.func_145831_w(), x, y, z, tileEntityIn.catalystItem);
        }
        matrixStack.func_227860_a_();
        IVertexBuilder buffer = iRenderTypeBuffer.getBuffer(model.func_228282_a_(texture));
        double sinOffset = Math.pow(Math.cos(((float)ClientInfo.ticksInGame + v) / 10.0f) / 4.0, 2.0);
        matrixStack.func_227861_a_(0.5, 0.5 + sinOffset, 0.5);
        float angle = ((float)ClientInfo.ticksInGame + v) / 5.0f % 360.0f;
        if (tileEntityIn.isCrafting) {
            World world = tileEntityIn.func_145831_w();
            BlockPos pos = tileEntityIn.func_174877_v().func_177963_a(0.0, 0.5, 0.0);
            Random rand = world.func_201674_k();
            for (int i = 0; i < 5; ++i) {
                Vec3d particlePos = new Vec3d((Vec3i)pos.func_177963_a(0.0, 0.5, 0.0)).func_72441_c(0.5, 0.0, 0.5);
                particlePos = particlePos.func_178787_e(ParticleUtil.pointInSphere(null));
                world.func_195594_a(ParticleLineData.createData(new ParticleColor(rand.nextInt(255), rand.nextInt(255), rand.nextInt(255))), particlePos.func_82615_a(), particlePos.func_82617_b(), particlePos.func_82616_c(), (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5);
            }
            EnchantingApparatusRenderer.model.frame_all.field_78795_f = angle;
            EnchantingApparatusRenderer.model.frame_bot.field_78796_g = angle;
            EnchantingApparatusRenderer.model.frame_top.field_78796_g = -angle;
            tileEntityIn.pedestalList().forEach(b -> {
                BlockPos pos2 = b.func_185334_h();
                for (int i = 0; i < 1; ++i) {
                    tileEntityIn.func_145831_w().func_195594_a(GlowParticleData.createData(new ParticleColor(rand.nextInt(255), rand.nextInt(255), rand.nextInt(255))), (double)pos2.func_177958_n() + 0.5 + ParticleUtil.inRange(-0.2, 0.2), (double)pos2.func_177956_o() + 1.5 + ParticleUtil.inRange(-0.3, 0.3), (double)pos2.func_177952_p() + 0.5 + ParticleUtil.inRange(-0.2, 0.2), 0.0, 0.0, 0.0);
                }
            });
        } else {
            EnchantingApparatusRenderer.model.frame_all.field_78795_f = 0.0f;
            EnchantingApparatusRenderer.model.frame_bot.field_78796_g = 0.0f;
            EnchantingApparatusRenderer.model.frame_top.field_78796_g = 0.0f;
        }
        model.func_225598_a_(matrixStack, buffer, lightIn, overlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
        ItemEntity entityItem = tileEntityIn.entity;
        matrixStack.func_227860_a_();
        RenderSystem.enableLighting();
        matrixStack.func_227861_a_(0.5, (double)0.55f + sinOffset, 0.5);
        matrixStack.func_227862_a_(0.35f, 0.35f, 0.35f);
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(entityItem.func_92059_d(), ItemCameraTransforms.TransformType.FIXED, 0xF000F0, overlayIn, matrixStack, iRenderTypeBuffer);
        matrixStack.func_227865_b_();
    }

    public static class ISRender
    extends ItemStackTileEntityRenderer {
        public void func_228364_a_(ItemStack p_228364_1_, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay) {
            ms.func_227860_a_();
            ms.func_227861_a_(0.75, 0.25, 0.2);
            IVertexBuilder buffer = buffers.getBuffer(model.func_228282_a_(texture));
            model.func_225598_a_(ms, buffer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            ms.func_227865_b_();
        }
    }
}

