/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.armor;

import java.util.function.Supplier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.LazyValue;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Materials {
    public static final IArmorMaterial novice = new ArmorMaterial("ars_nouveau:novice", 25, new int[]{1, 4, 5, 2}, 30, SoundEvents.field_187728_s, 0.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221603_aE}));
    public static final IArmorMaterial apprentice = new ArmorMaterial("ars_nouveau:apprentice", 25, new int[]{2, 5, 6, 2}, 30, SoundEvents.field_187728_s, 0.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_203183_eM}));
    public static final IArmorMaterial master = new ArmorMaterial("ars_nouveau:master", 33, new int[]{3, 6, 8, 3}, 30, SoundEvents.field_187728_s, 2.5f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_203183_eM}));

    private static class ArmorMaterial
    implements IArmorMaterial {
        private static final int[] Max_Damage_Array = new int[]{13, 15, 16, 11};
        private final String name;
        private final int maxDamageFactor;
        private final int[] damageReductionAmountArray;
        private final int enchantability;
        private final SoundEvent soundEvent;
        private final float toughness;
        private final LazyValue<Ingredient> repairMaterial;

        public ArmorMaterial(String name, int maxDamageFactor, int[] damageReductionAmountArray, int enchantability, SoundEvent soundEvent, float toughness, Supplier<Ingredient> supplier) {
            this.name = name;
            this.maxDamageFactor = maxDamageFactor;
            this.damageReductionAmountArray = damageReductionAmountArray;
            this.enchantability = enchantability;
            this.soundEvent = soundEvent;
            this.toughness = toughness;
            this.repairMaterial = new LazyValue(supplier);
        }

        public int func_200896_a(EquipmentSlotType slotIn) {
            return Max_Damage_Array[slotIn.func_188454_b()] * this.maxDamageFactor;
        }

        public int func_200902_b(EquipmentSlotType slotIn) {
            return this.damageReductionAmountArray[slotIn.func_188454_b()];
        }

        public int func_200900_a() {
            return this.enchantability;
        }

        public SoundEvent func_200899_b() {
            return this.soundEvent;
        }

        public Ingredient func_200898_c() {
            return (Ingredient)this.repairMaterial.func_179281_c();
        }

        @OnlyIn(value=Dist.CLIENT)
        public String func_200897_d() {
            return this.name;
        }

        public float func_200901_e() {
            return this.toughness;
        }
    }
}

