/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.PortUtil;
import com.hollingsworth.arsnouveau.common.block.ModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.RuneTile;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class RuneBlock
extends ModBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public RuneBlock() {
        super(RuneBlock.defaultProperties().func_200942_a().func_226896_b_().func_200948_a(0.0f, 0.0f), "rune");
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(handIn);
        if (!(stack.func_77973_b() instanceof SpellParchment) || worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ArrayList<AbstractSpellPart> recipe = SpellParchment.getSpellRecipe(stack);
        if (recipe == null || recipe.isEmpty()) {
            return ActionResultType.SUCCESS;
        }
        if (!(recipe.get(0) instanceof MethodTouch)) {
            PortUtil.sendMessage(player, (ITextComponent)new TranslationTextComponent("ars_nouveau.rune.touch", new Object[0]));
            return ActionResultType.SUCCESS;
        }
        ((RuneTile)worldIn.func_175625_s(pos)).setRecipe(recipe);
        PortUtil.sendMessage(player, "Spell set.");
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        super.func_196262_a(state, worldIn, pos, entityIn);
        if (worldIn.func_175625_s(pos) instanceof RuneTile) {
            ((RuneTile)worldIn.func_175625_s(pos)).castSpell(entityIn);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)0.5, (double)15.0);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new RuneTile();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{POWERED});
    }
}

