/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.AbstractManaTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.common.items.DominionWand;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ArcaneRelayTile
extends AbstractManaTile
implements ITooltipProvider,
IWandable {
    private BlockPos toPos;
    private BlockPos fromPos;

    public ArcaneRelayTile() {
        super(BlockRegistry.ARCANE_RELAY_TILE);
    }

    public ArcaneRelayTile(TileEntityType<?> type) {
        super(type);
    }

    public boolean closeEnough(BlockPos pos, int distance) {
        return BlockUtil.distanceFrom(pos, this.field_174879_c) <= (double)distance;
    }

    public boolean setTakeFrom(BlockPos pos) {
        if (BlockUtil.distanceFrom(pos, this.field_174879_c) > 10.0) {
            return false;
        }
        this.fromPos = pos;
        this.update();
        return true;
    }

    public boolean setSendTo(BlockPos pos) {
        if (BlockUtil.distanceFrom(pos, this.field_174879_c) > 10.0) {
            return false;
        }
        this.toPos = pos;
        this.update();
        return true;
    }

    public void clearPos() {
        this.toPos = null;
        this.fromPos = null;
        this.update();
    }

    @Override
    public int getTransferRate() {
        return 100;
    }

    @Override
    public int getMaxMana() {
        return 200;
    }

    @Override
    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, PlayerEntity playerEntity) {
        if (storedPos == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.setSendTo(storedPos.func_185334_h());
        playerEntity.func_145747_a((ITextComponent)new StringTextComponent("Relay set to send to " + DominionWand.getPosString(storedPos)));
        ParticleUtil.beam(storedPos, this.field_174879_c, (World)((ServerWorld)this.field_145850_b));
    }

    @Override
    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, PlayerEntity playerEntity) {
        if (storedPos == null) {
            return;
        }
        if (this.field_145850_b.func_175625_s(storedPos) instanceof ArcaneRelayTile) {
            return;
        }
        this.setTakeFrom(storedPos.func_185334_h());
        playerEntity.func_145747_a((ITextComponent)new StringTextComponent("Relay set to take from " + DominionWand.getPosString(storedPos)));
    }

    public void func_73660_a() {
        EntityFollowProjectile aoeProjectile;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 20L != 0L || this.toPos == null) {
            return;
        }
        if (this.fromPos != null) {
            AbstractManaTile fromTile;
            if (!(this.field_145850_b.func_175625_s(this.fromPos) instanceof AbstractManaTile)) {
                this.fromPos = null;
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
                return;
            }
            if (this.field_145850_b.func_175625_s(this.fromPos) instanceof AbstractManaTile && (fromTile = (AbstractManaTile)this.field_145850_b.func_175625_s(this.fromPos)).getCurrentMana() >= this.getTransferRate() && this.getCurrentMana() + this.getTransferRate() <= this.getMaxMana()) {
                fromTile.removeMana(this.getTransferRate());
                this.addMana(this.getTransferRate());
                aoeProjectile = new EntityFollowProjectile(this.field_145850_b, this.fromPos, this.field_174879_c);
                this.field_145850_b.func_217376_c((Entity)aoeProjectile);
            }
        }
        if (!(this.field_145850_b.func_175625_s(this.toPos) instanceof AbstractManaTile)) {
            this.toPos = null;
            this.update();
            return;
        }
        AbstractManaTile toTile = (AbstractManaTile)this.field_145850_b.func_175625_s(this.toPos);
        if (this.getCurrentMana() >= this.getTransferRate() && toTile.getCurrentMana() + this.getTransferRate() <= toTile.getMaxMana()) {
            this.removeMana(this.getTransferRate());
            toTile.addMana(this.getTransferRate());
            aoeProjectile = new EntityFollowProjectile(this.field_145850_b, this.field_174879_c, this.toPos);
            this.field_145850_b.func_217376_c((Entity)aoeProjectile);
        }
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        if (NBTUtil.hasBlockPos(tag, "to")) {
            this.toPos = NBTUtil.getBlockPos(tag, "to");
        }
        if (NBTUtil.hasBlockPos(tag, "from")) {
            this.fromPos = NBTUtil.getBlockPos(tag, "from");
        }
        super.func_145839_a(tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        if (this.toPos != null) {
            NBTUtil.storeBlockPos(tag, "to", this.toPos);
        }
        if (this.fromPos != null) {
            NBTUtil.storeBlockPos(tag, "from", this.fromPos);
        }
        return super.func_189515_b(tag);
    }

    @Override
    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    @Override
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.toPos == null) {
            list.add(new TranslationTextComponent("ars_nouveau.relay.no_to", new Object[0]).getString());
        } else {
            list.add(new TranslationTextComponent("ars_nouveau.relay.one_to", new Object[]{1}).getString());
        }
        if (this.fromPos == null) {
            list.add(new TranslationTextComponent("ars_nouveau.relay.no_from", new Object[0]).getString());
        } else {
            list.add(new TranslationTextComponent("ars_nouveau.relay.one_from", new Object[]{1}).getString());
        }
        return list;
    }
}

