/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.IEnchantingRecipe;
import com.hollingsworth.arsnouveau.common.block.tile.AnimatedTile;
import com.hollingsworth.arsnouveau.common.block.tile.ArcanePedestalTile;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;

public class EnchantingApparatusTile
extends AnimatedTile {
    public ItemStack catalystItem;
    public ItemEntity entity;
    public long frames = 0L;
    private int craftingLength = 100;
    public boolean isCrafting;
    public long timeStartedCrafting;

    public EnchantingApparatusTile() {
        super(BlockRegistry.ENCHANTING_APP_TILE);
        this.counter = 1;
    }

    public void func_73660_a() {
        if (this.isCrafting && !this.field_145850_b.field_72995_K) {
            if (this.getRecipe() == null) {
                this.isCrafting = false;
            }
            ++this.counter;
        }
        if (this.counter > this.craftingLength && !this.field_145850_b.field_72995_K) {
            this.counter = 1;
            if (this.isCrafting) {
                IEnchantingRecipe recipe = this.getRecipe();
                List<ItemStack> pedestalItems = this.getPedestalItems();
                if (recipe != null) {
                    pedestalItems.forEach(i -> {
                        i = null;
                    });
                    this.catalystItem = recipe.getResult(pedestalItems, this.catalystItem, this);
                    this.clearItems();
                }
                this.isCrafting = false;
            }
            this.updateBlock();
        } else if (this.field_145850_b.field_72995_K && this.counter >= this.craftingLength - 1) {
            this.spawnPoofParticles();
        }
    }

    public void spawnPoofParticles() {
        for (int i = 0; i < 10; ++i) {
            double d0 = (double)this.func_174877_v().func_177958_n() + 0.5;
            double d1 = (double)this.func_174877_v().func_177956_o() + 1.2;
            double d2 = (double)this.func_174877_v().func_177952_p() + 0.5;
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197624_q, d0, d1, d2, ((double)(this.field_145850_b.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(this.field_145850_b.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(this.field_145850_b.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0);
        }
    }

    public void clearItems() {
        BlockPos.func_218281_b((BlockPos)this.func_174877_v().func_177982_a(5, -3, 5), (BlockPos)this.func_174877_v().func_177982_a(-5, 3, -5)).forEach(blockPos -> {
            if (this.field_145850_b.func_175625_s(blockPos) instanceof ArcanePedestalTile && ((ArcanePedestalTile)this.field_145850_b.func_175625_s((BlockPos)blockPos)).stack != null) {
                ArcanePedestalTile tile = (ArcanePedestalTile)this.field_145850_b.func_175625_s(blockPos);
                tile.stack = tile.stack.func_77973_b() == ItemsRegistry.bucketOfMana ? new ItemStack((IItemProvider)Items.field_151133_ar) : ItemStack.field_190927_a;
                BlockState state = this.field_145850_b.func_180495_p(blockPos);
                this.field_145850_b.func_184138_a(blockPos, state, state, 3);
            }
        });
    }

    public List<BlockPos> pedestalList() {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        BlockPos.func_218281_b((BlockPos)this.func_174877_v().func_177982_a(5, -3, 5), (BlockPos)this.func_174877_v().func_177982_a(-5, 3, -5)).forEach(blockPos -> {
            if (this.field_145850_b.func_175625_s(blockPos) instanceof ArcanePedestalTile && ((ArcanePedestalTile)this.field_145850_b.func_175625_s((BlockPos)blockPos)).stack != null && !((ArcanePedestalTile)this.field_145850_b.func_175625_s((BlockPos)blockPos)).stack.func_190926_b()) {
                posList.add(blockPos.func_185334_h());
            }
        });
        return posList;
    }

    public List<ItemStack> getPedestalItems() {
        ArrayList<ItemStack> pedestalItems = new ArrayList<ItemStack>();
        BlockPos.func_218281_b((BlockPos)this.func_174877_v().func_177982_a(5, -3, 5), (BlockPos)this.func_174877_v().func_177982_a(-5, 3, -5)).forEach(blockPos -> {
            if (this.field_145850_b.func_175625_s(blockPos) instanceof ArcanePedestalTile && ((ArcanePedestalTile)this.field_145850_b.func_175625_s((BlockPos)blockPos)).stack != null && !((ArcanePedestalTile)this.field_145850_b.func_175625_s((BlockPos)blockPos)).stack.func_190926_b()) {
                pedestalItems.add(((ArcanePedestalTile)this.field_145850_b.func_175625_s((BlockPos)blockPos)).stack);
            }
        });
        return pedestalItems;
    }

    public IEnchantingRecipe getRecipe() {
        List<ItemStack> pedestalItems = this.getPedestalItems();
        return ArsNouveauAPI.getInstance().getEnchantingApparatusRecipes().stream().filter(r -> r.isMatch(pedestalItems, this.catalystItem, this)).findFirst().orElse(null);
    }

    public void attemptCraft() {
        if (this.catalystItem == null || this.isCrafting) {
            return;
        }
        if (this.getRecipe() != null) {
            this.isCrafting = true;
        }
        this.updateBlock();
    }

    public void updateBlock() {
        if (this.counter == 0) {
            this.counter = 1;
        }
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        this.catalystItem = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)compound.func_74781_a("itemStack")));
        this.isCrafting = compound.func_74767_n("is_crafting");
        this.counter = compound.func_74762_e("counter");
        super.func_145839_a(compound);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.catalystItem != null) {
            CompoundNBT reagentTag = new CompoundNBT();
            this.catalystItem.func_77955_b(reagentTag);
            compound.func_218657_a("itemStack", (INBT)reagentTag);
        }
        compound.func_74757_a("is_crafting", this.isCrafting);
        compound.func_74768_a("counter", this.counter);
        return super.func_189515_b(compound);
    }

    @Override
    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("counter", this.counter);
        tag.func_74757_a("is_crafting", this.isCrafting);
        return this.func_189515_b(tag);
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }
}

