/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.common.block.GlyphPressBlock;
import com.hollingsworth.arsnouveau.common.block.tile.AnimatedTile;
import com.hollingsworth.arsnouveau.common.block.tile.ManaJarTile;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class GlyphPressTile
extends AnimatedTile
implements ITickableTileEntity,
IInventory {
    public long frames = 0L;
    public boolean isCrafting;
    public ItemStack reagentItem;
    public ItemStack baseMaterial;
    public ItemEntity entity;
    public long timeStartedSpraying;

    public GlyphPressTile() {
        super(BlockRegistry.GLYPH_PRESS_TILE);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        this.reagentItem = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)compound.func_74781_a("itemStack")));
        this.baseMaterial = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)compound.func_74781_a("baseMat")));
        this.isCrafting = compound.func_74767_n("crafting");
        this.timeStartedSpraying = compound.func_74763_f("spraying");
        super.func_145839_a(compound);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.reagentItem != null) {
            CompoundNBT reagentTag = new CompoundNBT();
            this.reagentItem.func_77955_b(reagentTag);
            compound.func_218657_a("itemStack", (INBT)reagentTag);
        }
        if (this.baseMaterial != null) {
            CompoundNBT baseMatTag = new CompoundNBT();
            this.baseMaterial.func_77955_b(baseMatTag);
            compound.func_218657_a("baseMat", (INBT)baseMatTag);
        }
        compound.func_74757_a("crafting", this.isCrafting);
        compound.func_74772_a("spraying", this.timeStartedSpraying);
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        if (!this.isCrafting) {
            return;
        }
        if (this.field_145850_b.field_72995_K && this.counter != 20) {
            return;
        }
        if (this.counter < 9) {
            ++this.counter;
            this.updateBlock();
        } else if (this.counter <= 19) {
            if (this.field_145850_b.func_82737_E() % 2L != 0L) {
                return;
            }
            ++this.counter;
            if (this.counter == 19) {
                this.timeStartedSpraying = this.field_145850_b.func_82737_E();
            }
            this.updateBlock();
        } else if (this.counter <= 20) {
            if (this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 2L != 0L) {
                for (int i = 0; i < 1; ++i) {
                    double posX = this.field_174879_c.func_177958_n();
                    double posY = this.field_174879_c.func_177956_o();
                    double posZ = this.field_174879_c.func_177952_p();
                    double randX = (double)this.field_145850_b.field_73012_v.nextFloat() > 0.5 ? (double)this.field_145850_b.field_73012_v.nextFloat() : (double)(-this.field_145850_b.field_73012_v.nextFloat());
                    double randZ = (double)this.field_145850_b.field_73012_v.nextFloat() > 0.5 ? (double)this.field_145850_b.field_73012_v.nextFloat() : (double)(-this.field_145850_b.field_73012_v.nextFloat());
                    double d0 = posX + 0.5 + randX * 0.2;
                    double d1 = posY + 0.4;
                    double d2 = posZ + 0.5 + randZ * 0.2;
                    double spdX = (double)this.field_145850_b.field_73012_v.nextFloat() > 0.5 ? (double)this.field_145850_b.field_73012_v.nextFloat() : (double)(-this.field_145850_b.field_73012_v.nextFloat());
                    double spdZ = (double)this.field_145850_b.field_73012_v.nextFloat() > 0.5 ? (double)this.field_145850_b.field_73012_v.nextFloat() : (double)(-this.field_145850_b.field_73012_v.nextFloat());
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197622_o, d0, d1, d2, spdX * 0.05, 0.0, spdZ * 0.05);
                }
                return;
            }
            if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() - this.timeStartedSpraying > 100L) {
                ++this.counter;
                Glyph glyph = ArsNouveauAPI.getInstance().hasCraftingReagent(this.reagentItem.func_77973_b());
                this.baseMaterial = new ItemStack((IItemProvider)glyph);
                this.updateBlock();
            }
        } else if (this.counter < 31) {
            if (this.field_145850_b.func_82737_E() % 2L != 0L) {
                return;
            }
            ++this.counter;
            if (this.counter == 31) {
                Glyph glyph = ArsNouveauAPI.getInstance().hasCraftingReagent(this.reagentItem.func_77973_b());
                AtomicBoolean canContinue = new AtomicBoolean(false);
                int manaCost = glyph.spellPart.getTier() == ISpellTier.Tier.ONE ? 2000 : (glyph.spellPart.getTier() == ISpellTier.Tier.TWO ? 4000 : 6000);
                BlockPos.func_218281_b((BlockPos)this.func_174877_v().func_177982_a(5, -3, 5), (BlockPos)this.func_174877_v().func_177982_a(-5, 3, -5)).forEach(blockPos -> {
                    if (this.field_145850_b.func_175625_s(blockPos) instanceof ManaJarTile && ((ManaJarTile)this.field_145850_b.func_175625_s(blockPos)).getCurrentMana() >= manaCost && !canContinue.get()) {
                        ((ManaJarTile)this.field_145850_b.func_175625_s(blockPos)).removeMana(manaCost);
                        canContinue.set(true);
                        return;
                    }
                });
                this.counter = 1;
                this.field_145850_b.func_217376_c((Entity)new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, new ItemStack((IItemProvider)glyph)));
                this.reagentItem = new ItemStack(null);
                this.baseMaterial = new ItemStack(null);
                this.isCrafting = false;
            }
            this.updateBlock();
        }
    }

    public void updateBlock() {
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a(GlyphPressBlock.stage, (Comparable)Integer.valueOf(this.counter)), 3);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
    }

    public Item getMatchingClay(ISpellTier.Tier tier) {
        if (tier == ISpellTier.Tier.ONE) {
            return ItemsRegistry.magicClay;
        }
        if (tier == ISpellTier.Tier.TWO) {
            return ItemsRegistry.marvelousClay;
        }
        return ItemsRegistry.mythicalClay;
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_191420_l() {
        return false;
    }

    public ItemStack func_70301_a(int index) {
        return this.reagentItem;
    }

    public ItemStack func_70298_a(int index, int count) {
        this.reagentItem.func_190918_g(1);
        return this.reagentItem;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.reagentItem;
        this.reagentItem.func_190920_e(0);
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.reagentItem = stack;
        System.out.println("Setting slot");
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public void func_174888_l() {
        this.reagentItem = null;
    }

    public boolean craft(PlayerEntity playerEntity) {
        if (this.isCrafting) {
            return false;
        }
        Glyph glyph = ArsNouveauAPI.getInstance().hasCraftingReagent(this.reagentItem.func_77973_b());
        int manaCost = glyph.spellPart.getTier() == ISpellTier.Tier.ONE ? 2000 : (glyph.spellPart.getTier() == ISpellTier.Tier.TWO ? 4000 : 6000);
        AtomicBoolean valid = new AtomicBoolean(false);
        if (glyph == null) {
            return false;
        }
        AtomicReference jar = new AtomicReference();
        BlockPos.func_218281_b((BlockPos)this.func_174877_v().func_177982_a(5, -3, 5), (BlockPos)this.func_174877_v().func_177982_a(-5, 3, -5)).forEach(blockPos -> {
            if (this.field_145850_b.func_175625_s(blockPos) instanceof ManaJarTile && ((ManaJarTile)this.field_145850_b.func_175625_s(blockPos)).getCurrentMana() >= manaCost) {
                valid.set(true);
                jar.set(new BlockPos((Vec3i)blockPos));
            }
        });
        if (!valid.get()) {
            playerEntity.func_145747_a((ITextComponent)new StringTextComponent("There does not appear to be enough mana nearby. "));
        }
        if (glyph != null && valid.get() && this.baseMaterial != null && this.getMatchingClay(glyph.spellPart.getTier()) == this.baseMaterial.func_77973_b() && this.field_145850_b.func_175625_s((BlockPos)jar.get()) instanceof ManaJarTile && ((ManaJarTile)this.field_145850_b.func_175625_s((BlockPos)jar.get())).getCurrentMana() >= manaCost) {
            ((ManaJarTile)this.field_145850_b.func_175625_s((BlockPos)jar.get())).removeMana(manaCost);
            this.isCrafting = true;
            return true;
        }
        return false;
    }
}

