/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.api.util.SpellRecipeUtil;
import com.hollingsworth.arsnouveau.common.block.RuneBlock;
import com.hollingsworth.arsnouveau.common.block.tile.AnimatedTile;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayerFactory;

public class RuneTile
extends AnimatedTile {
    public List<AbstractSpellPart> recipe;
    public boolean isTemporary = false;
    public boolean isCharged = true;
    public int ticksUntilCharge = 0;

    public RuneTile() {
        super(BlockRegistry.RUNE_TILE);
    }

    public void setRecipe(ArrayList<AbstractSpellPart> recipe) {
        this.recipe = recipe;
    }

    public void castSpell(Entity entity) {
        if (!(this.isCharged && this.recipe != null && !this.recipe.isEmpty() && entity instanceof LivingEntity && this.field_145850_b instanceof ServerWorld && this.recipe.get(0) instanceof MethodTouch)) {
            return;
        }
        try {
            EntitySpellResolver resolver = new EntitySpellResolver(this.recipe, new SpellContext(this.recipe, (LivingEntity)FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.field_145850_b))).withCastingTile(this));
            resolver.onCastOnEntity(ItemStack.field_190927_a, (LivingEntity)FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.field_145850_b)), (LivingEntity)entity, Hand.MAIN_HAND);
            if (this.isTemporary) {
                this.field_145850_b.func_175655_b(this.field_174879_c, false);
                return;
            }
            this.isCharged = false;
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_177231_a((IProperty)RuneBlock.POWERED));
            this.ticksUntilCharge = 40;
        }
        catch (Exception e) {
            entity.func_145747_a((ITextComponent)new TranslationTextComponent("ars_nouveau.rune.error", new Object[0]));
            e.printStackTrace();
            this.field_145850_b.func_175655_b(this.field_174879_c, false);
        }
    }

    public void setParsedSpell(List<AbstractSpellPart> spell) {
        if (spell.size() <= 1) {
            this.recipe = null;
            return;
        }
        spell.set(0, new MethodTouch());
        this.recipe = spell;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        if (this.recipe != null) {
            tag.func_74778_a("spell", SpellRecipeUtil.serializeForNBT(this.recipe));
        }
        tag.func_74757_a("charged", this.isCharged);
        tag.func_74757_a("temp", this.isTemporary);
        tag.func_74768_a("cooldown", this.ticksUntilCharge);
        return super.func_189515_b(tag);
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        this.recipe = SpellRecipeUtil.getSpellsFromTagString(tag.func_74779_i("spell"));
        this.isCharged = tag.func_74767_n("charged");
        this.isTemporary = tag.func_74767_n("temp");
        this.ticksUntilCharge = tag.func_74762_e("cooldown");
        super.func_145839_a(tag);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.ticksUntilCharge > 0) {
            --this.ticksUntilCharge;
            return;
        }
        if (this.isCharged) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.isTemporary) {
            this.field_145850_b.func_175655_b(this.field_174879_c, false);
        }
        if (!this.field_145850_b.field_72995_K && !this.isCharged) {
            BlockPos fromPos = ManaUtil.takeManaNearby(this.field_174879_c, this.field_145850_b, 10, 100);
            if (fromPos != null) {
                this.isCharged = true;
                Networking.sendToNearby(this.field_145850_b, this.field_174879_c, (Object)new PacketANEffect(PacketANEffect.EffectType.TIMED_GLOW, this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), fromPos.func_177958_n(), fromPos.func_177956_o(), fromPos.func_177952_p(), 5));
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_177231_a((IProperty)RuneBlock.POWERED));
            } else {
                this.ticksUntilCharge = 60;
            }
        }
    }
}

