/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.IPickupResponder;
import com.hollingsworth.arsnouveau.api.spell.IPlaceBlockResponder;
import com.hollingsworth.arsnouveau.api.util.SpellRecipeUtil;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpellTurretTile
extends TileEntity
implements IPickupResponder,
IPlaceBlockResponder,
ITooltipProvider {
    public List<AbstractSpellPart> recipe;

    public SpellTurretTile() {
        super(BlockRegistry.SPELL_TURRET_TYPE);
    }

    @Override
    public ItemStack onPickup(ItemStack stack) {
        for (IInventory i : this.inventories()) {
            if (stack == ItemStack.field_190927_a || stack == null) break;
            stack = HopperTileEntity.func_174918_a(null, (IInventory)i, (ItemStack)stack, null);
        }
        return stack;
    }

    @Override
    public ItemStack onPlaceBlock() {
        for (IInventory inv : this.inventories()) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                if (!(inv.func_70301_a(i).func_77973_b() instanceof BlockItem)) continue;
                return inv.func_70301_a(i);
            }
        }
        return null;
    }

    public List<IInventory> inventories() {
        if (this.field_145850_b == null) {
            return new ArrayList<IInventory>();
        }
        ArrayList<IInventory> iInventories = new ArrayList<IInventory>();
        for (Direction d : Direction.values()) {
            IInventory iInventory = HopperTileEntity.func_195484_a((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(d));
            if (iInventory == null) continue;
            iInventories.add(iInventory);
        }
        return iInventories;
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        if (this.recipe != null) {
            tag.func_74778_a("spell", SpellRecipeUtil.serializeForNBT(this.recipe));
        }
        return super.func_189515_b(tag);
    }

    public void func_145839_a(CompoundNBT tag) {
        this.recipe = SpellRecipeUtil.getSpellsFromTagString(tag.func_74779_i("spell"));
        super.func_145839_a(tag);
    }

    @Override
    public List<String> getTooltip() {
        if (this.recipe == null || this.recipe.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add("Casting: " + SpellRecipeUtil.getDisplayString(this.recipe));
        return list;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }
}

