/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.common.block.ManaBlock;
import com.hollingsworth.arsnouveau.common.block.SummoningCrystal;
import com.hollingsworth.arsnouveau.common.block.tile.AbstractManaTile;
import com.hollingsworth.arsnouveau.common.block.tile.ManaJarTile;
import com.hollingsworth.arsnouveau.common.entity.EntityWhelp;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class SummoningCrytalTile
extends AbstractManaTile {
    ArrayList<UUID> entityList = new ArrayList();
    int numEntities = 0;
    int tier = 1;
    int taskIndex;
    public boolean isOff;
    public static final String ENTITY_TAG = "entity";

    public SummoningCrytalTile() {
        super(BlockRegistry.SUMMONING_CRYSTAL_TILE);
    }

    @Override
    public int getTransferRate() {
        return 0;
    }

    public void summon(LivingEntity entity) {
        if (!this.field_145850_b.field_72995_K) {
            ++this.numEntities;
            this.entityList.add(entity.func_110124_au());
        }
    }

    public void changeTier(PlayerEntity entity) {
        if (this.tier == 1) {
            this.tier = 2;
            entity.func_145747_a((ITextComponent)new StringTextComponent("Set area to 5 x 5"));
        } else if (this.tier == 2) {
            this.tier = 3;
            entity.func_145747_a((ITextComponent)new StringTextComponent("Set area to 9 x 9"));
        } else if (this.tier == 3) {
            this.tier = 1;
            entity.func_145747_a((ITextComponent)new StringTextComponent("Set area to adjacent blocks only."));
        }
    }

    public List<IInventory> inventories() {
        if (this.field_145850_b == null) {
            return new ArrayList<IInventory>();
        }
        ArrayList<IInventory> iInventories = new ArrayList<IInventory>();
        for (Direction d : Direction.values()) {
            IInventory iInventory = HopperTileEntity.func_195484_a((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(d));
            if (iInventory == null) continue;
            iInventories.add(iInventory);
        }
        return iInventories;
    }

    public ItemStack insertItem(ItemStack stack) {
        for (IInventory i : this.inventories()) {
            if (stack == ItemStack.field_190927_a || stack == null) break;
            stack = HopperTileEntity.func_174918_a(null, (IInventory)i, (ItemStack)stack, null);
        }
        return stack;
    }

    public ItemStack getItem(Item item) {
        ItemStack stack = ItemStack.field_190927_a;
        for (IInventory inv : this.inventories()) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                if (inv.func_70301_a(i).func_77973_b() != item) continue;
                return inv.func_70301_a(i);
            }
        }
        return stack;
    }

    public boolean isTree(Block block) {
        return block instanceof LogBlock || block instanceof LeavesBlock;
    }

    @Nullable
    public BlockPos getNextTaskLoc(@Nullable List<AbstractSpellPart> recipe, EntityWhelp caster) {
        SpellResolver resolver;
        Block block;
        if (this.isOff) {
            return null;
        }
        List<BlockPos> posList = this.getTargets();
        if (posList == null || posList.isEmpty()) {
            return null;
        }
        if (this.taskIndex + 1 > posList.size()) {
            this.taskIndex = 0;
        }
        BlockPos taskPos = posList.get(this.taskIndex);
        ++this.taskIndex;
        if (this.field_145850_b.func_180495_p(taskPos.func_177984_a()).func_185904_a() != Material.field_151579_a && !this.isTree(this.field_145850_b.func_180495_p(taskPos).func_177230_c())) {
            for (int i = 1; i < 4; ++i) {
                if (this.field_145850_b.func_180495_p(taskPos.func_177981_b(i)).func_185904_a() == Material.field_151579_a && !this.isTree(this.field_145850_b.func_180495_p(taskPos.func_177984_a()).func_177230_c())) continue;
                taskPos = taskPos.func_177981_b(i);
                break;
            }
        }
        if ((block = this.field_145850_b.func_180495_p(taskPos).func_177230_c()) instanceof SummoningCrystal || block instanceof ContainerBlock || block instanceof ManaBlock || block instanceof IInventory) {
            return null;
        }
        if (recipe != null && ((Boolean)caster.func_184212_Q().func_187225_a(EntityWhelp.STRICT_MODE)).booleanValue() && !(resolver = new SpellResolver(recipe, new SpellContext(recipe, (LivingEntity)caster))).wouldCastOnBlockSuccessfully(new BlockRayTraceResult(new Vec3d((double)taskPos.func_177958_n(), (double)taskPos.func_177956_o(), (double)taskPos.func_177952_p()), Direction.UP, taskPos, false), (LivingEntity)caster)) {
            return null;
        }
        return taskPos;
    }

    public boolean enoughMana(List<AbstractSpellPart> spellParts) {
        return this.enoughMana(ManaUtil.getRecipeCost(spellParts) / 4);
    }

    public boolean enoughMana(int manaCost) {
        boolean[] enough = new boolean[]{false};
        BlockPos.func_218281_b((BlockPos)this.func_174877_v().func_177982_a(9, -3, 9), (BlockPos)this.func_174877_v().func_177982_a(-9, 3, -9)).forEach(blockPos -> {
            if (!enough[0] && this.field_145850_b.func_175625_s(blockPos) instanceof ManaJarTile && ((ManaJarTile)this.field_145850_b.func_175625_s(blockPos)).getCurrentMana() >= manaCost) {
                enough[0] = true;
            }
        });
        return enough[0];
    }

    public boolean removeManaAround(int manaCost) {
        boolean[] enough = new boolean[]{false};
        BlockPos.func_218281_b((BlockPos)this.func_174877_v().func_177982_a(9, -3, 9), (BlockPos)this.func_174877_v().func_177982_a(-9, 3, -9)).forEach(blockPos -> {
            if (!enough[0] && this.field_145850_b.func_175625_s(blockPos) instanceof ManaJarTile && ((ManaJarTile)this.field_145850_b.func_175625_s(blockPos)).getCurrentMana() >= manaCost && !this.field_145850_b.field_72995_K) {
                ((ManaJarTile)this.field_145850_b.func_175625_s(blockPos)).removeMana(manaCost);
                enough[0] = true;
                Networking.sendToNearby(this.field_145850_b, this.field_174879_c, (Object)new PacketANEffect(PacketANEffect.EffectType.TIMED_GLOW, this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), 5));
            }
        });
        return enough[0];
    }

    public boolean removeManaAround(List<AbstractSpellPart> spellParts) {
        return this.removeManaAround(ManaUtil.getRecipeCost(spellParts) / 4);
    }

    public List<BlockPos> getTargets() {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        if (this.tier == 1) {
            positions.add(this.func_174877_v().func_177978_c().func_177977_b());
            positions.add(this.func_174877_v().func_177968_d().func_177977_b());
            positions.add(this.func_174877_v().func_177974_f().func_177977_b());
            positions.add(this.func_174877_v().func_177976_e().func_177977_b());
        }
        if (this.tier == 2) {
            BlockPos.func_218281_b((BlockPos)this.func_174877_v().func_177964_d(2).func_177965_g(2).func_177979_c(1), (BlockPos)this.func_174877_v().func_177970_e(2).func_177985_f(2).func_177977_b()).forEach(t -> positions.add(new BlockPos((Vec3i)t)));
        }
        if (this.tier == 3) {
            BlockPos.func_218281_b((BlockPos)this.func_174877_v().func_177964_d(4).func_177965_g(4).func_177979_c(1), (BlockPos)this.func_174877_v().func_177970_e(4).func_177985_f(4).func_177977_b()).forEach(t -> positions.add(new BlockPos((Vec3i)t)));
        }
        return positions;
    }

    public void cleanupKobolds() {
        List list = this.field_145850_b.func_217357_a(EntityWhelp.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(10.0)).stream().map(f -> f.func_110124_au()).collect(Collectors.toList());
        ArrayList<UUID> removed = new ArrayList<UUID>();
        for (UUID uuid : this.entityList) {
            if (list.contains(uuid)) continue;
            removed.add(uuid);
        }
        for (UUID uuid : removed) {
            this.entityList.remove(uuid);
            --this.numEntities;
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_82737_E() % 20L != 0L || this.field_145850_b.field_72995_K) {
            return;
        }
        this.cleanupKobolds();
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.numEntities = tag.func_74762_e("entities");
        int count = 0;
        while (tag.func_186855_b(ENTITY_TAG + count)) {
            this.entityList.add(tag.func_186857_a(ENTITY_TAG + count));
            ++count;
        }
        this.taskIndex = tag.func_74762_e("task_index");
        this.tier = tag.func_74762_e("tier");
        this.isOff = tag.func_74767_n("is_off");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("entities", this.numEntities);
        for (int i = 0; i < this.entityList.size(); ++i) {
            tag.func_186854_a(ENTITY_TAG + i, this.entityList.get(i));
        }
        tag.func_74768_a("task_index", this.taskIndex);
        tag.func_74768_a("tier", this.tier);
        tag.func_74757_a("is_off", this.isOff);
        return super.func_189515_b(tag);
    }
}

