/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.recipe.ShapedHelper;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.WixieCauldron;
import com.hollingsworth.arsnouveau.common.entity.EntityFlyingItem;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.common.entity.EntityWixie;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class WixieCauldronTile
extends TileEntity
implements ITickableTileEntity {
    List<ItemStack> itemsToCraft;
    List<ItemStack> itemsRequired;
    ItemStack craftingItem;
    public List<BlockPos> inventories;
    int itemCounter;
    int recipeItemCounter;
    boolean converted;

    public WixieCauldronTile() {
        super(BlockRegistry.WIXIE_CAULDRON_TYPE);
    }

    public void func_73660_a() {
        if (!this.converted) {
            this.convertedEffect();
            return;
        }
        if (this.field_145850_b.func_82737_E() % 100L == 0L && !this.field_145850_b.field_72995_K) {
            this.updateCrafting();
            this.updateInventories();
        }
        if (this.itemsRequired == null) {
            return;
        }
        if (this.itemsRequired.isEmpty() && this.craftingItem != null && !this.craftingItem.func_190926_b()) {
            ItemEntity entity = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5);
            entity.func_92058_a(this.craftingItem);
            this.craftingItem = ItemStack.field_190927_a;
        }
    }

    public ItemStack getNextRequiredItem() {
        if (this.itemsRequired == null || this.itemsRequired.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        if (this.recipeItemCounter > this.itemsRequired.size()) {
            this.recipeItemCounter = 0;
        }
        ItemStack stack = this.itemsRequired.get(this.recipeItemCounter);
        ++this.recipeItemCounter;
        return stack;
    }

    public boolean giveItem(ItemStack stack) {
        return this.itemsToCraft.remove(stack);
    }

    public void updateInventories() {
        if (this.inventories == null) {
            this.inventories = new ArrayList<BlockPos>();
        }
        for (BlockPos bPos : BlockPos.func_218278_a((BlockPos)this.field_174879_c.func_177964_d(6).func_177979_c(2), (BlockPos)this.field_174879_c.func_177970_e(6).func_177981_b(2))) {
            if (!(this.field_145850_b.func_175625_s(bPos) instanceof IInventory)) continue;
            this.inventories.add(bPos.func_185334_h());
        }
    }

    public void updateCrafting() {
        if (this.itemsToCraft == null || this.itemsToCraft.isEmpty() || this.craftingItem != null) {
            return;
        }
        ++this.itemCounter;
        if (this.itemCounter > this.itemsToCraft.size()) {
            this.itemCounter = 0;
        }
        this.craftingItem = this.itemsToCraft.get(this.itemCounter).func_77946_l();
    }

    public void spawnFlyingItem(BlockPos from) {
        EntityFlyingItem flyingItem = new EntityFlyingItem(this.field_145850_b, from, this.field_174879_c.func_177977_b());
        this.field_145850_b.func_217376_c((Entity)flyingItem);
    }

    public void addItem(ItemStack stack) {
        if (this.itemsToCraft == null) {
            this.itemsToCraft = new ArrayList<ItemStack>();
        }
        this.itemsToCraft.add(stack);
    }

    public void convertedEffect() {
        ++this.itemCounter;
        if (this.itemCounter >= 120 && !this.field_145850_b.field_72995_K) {
            this.converted = true;
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)((BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((IProperty)WixieCauldron.FILLED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WixieCauldron.CONVERTED, (Comparable)Boolean.valueOf(true)));
            EntityWixie wixie = new EntityWixie(this.field_145850_b, true, this.field_174879_c);
            wixie.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5);
            this.field_145850_b.func_217376_c((Entity)wixie);
            ParticleUtil.spawnPoof((ServerWorld)this.field_145850_b, this.field_174879_c.func_177984_a());
            this.itemCounter = 0;
            return;
        }
        if (this.itemCounter % 10 == 0 && !this.field_145850_b.field_72995_K) {
            Random r = this.field_145850_b.field_73012_v;
            int min = -2;
            int max = 2;
            EntityFollowProjectile proj1 = new EntityFollowProjectile(this.field_145850_b, this.field_174879_c.func_177982_a(r.nextInt(max - min) + min, 3, r.nextInt(max - min) + min), this.field_174879_c, r.nextInt(255), r.nextInt(255), r.nextInt(255));
            this.field_145850_b.func_217376_c((Entity)proj1);
        }
    }

    public void getRecipes(ItemStack stack) {
        ArrayList<List<Object>> ingredientList = new ArrayList<List<Object>>();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (IRecipe r : this.field_145850_b.func_73046_m().func_199529_aN().func_199510_b()) {
            if (!r.func_77571_b().func_77969_a(stack)) continue;
            if (r instanceof ShapedRecipe && r.func_77571_b().func_77969_a(stack)) {
                ShapedHelper helper = new ShapedHelper((ShapedRecipe)r);
                for (List<Ingredient> iList : helper.matches()) {
                    if (ingredientList.contains(iList)) continue;
                    ingredientList.add(iList);
                }
            }
            if (!(r instanceof ShapelessRecipe) || ingredientList.contains(r.func_192400_c())) continue;
            ingredientList.add((List<Object>)r.func_192400_c());
        }
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("numItems")) {
            this.itemsToCraft = new ArrayList<ItemStack>();
            int numItems = compound.func_74762_e("numItems");
            for (int i = 0; i < numItems; ++i) {
                this.itemsToCraft.add(ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("item" + i)));
            }
        }
        this.converted = compound.func_74767_n("converted");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.itemsToCraft != null) {
            for (int i = 0; i < this.itemsToCraft.size(); ++i) {
                CompoundNBT itemTag = new CompoundNBT();
                this.itemsToCraft.get(0).func_77955_b(itemTag);
                compound.func_218657_a("item" + i, (INBT)itemTag);
            }
            compound.func_74768_a("numItems", this.itemsToCraft.size());
        }
        compound.func_74757_a("converted", this.converted);
        return super.func_189515_b(compound);
    }
}

