/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.capability;

import com.hollingsworth.arsnouveau.api.mana.IMana;
import com.hollingsworth.arsnouveau.common.capability.Mana;
import com.hollingsworth.arsnouveau.common.capability.SerializableCapabilityProvider;
import com.hollingsworth.arsnouveau.setup.InjectionUtil;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ManaCapability {
    @CapabilityInject(value=IMana.class)
    public static final Capability<IMana> MANA_CAPABILITY = (Capability)InjectionUtil.Null();
    public static final Direction DEFAULT_FACING = null;
    public static final ResourceLocation ID = new ResourceLocation("ars_nouveau", "mana");

    public static void register() {
        CapabilityManager.INSTANCE.register(IMana.class, (Capability.IStorage)new Capability.IStorage<IMana>(){

            @Nullable
            public INBT writeNBT(Capability<IMana> capability, IMana instance, Direction side) {
                CompoundNBT tag = new CompoundNBT();
                tag.func_74768_a("current", instance.getCurrentMana());
                tag.func_74768_a("max", instance.getMaxMana());
                tag.func_74768_a("glyph", instance.getGlyphBonus());
                tag.func_74768_a("book_tier", instance.getBookTier());
                return tag;
            }

            public void readNBT(Capability<IMana> capability, IMana instance, Direction side, INBT nbt) {
                if (!(nbt instanceof CompoundNBT)) {
                    return;
                }
                CompoundNBT tag = (CompoundNBT)nbt;
                instance.setMaxMana(tag.func_74762_e("max"));
                instance.setMana(tag.func_74762_e("current"));
                instance.setBookTier(tag.func_74762_e("book_tier"));
                instance.setGlyphBonus(tag.func_74762_e("glyph"));
            }
        }, () -> new Mana(null));
        System.out.println("Finished Registering ManaCapability");
    }

    public static LazyOptional<IMana> getMana(LivingEntity entity) {
        return entity.getCapability(MANA_CAPABILITY, DEFAULT_FACING);
    }

    public static ICapabilityProvider createProvider(IMana mana) {
        return new SerializableCapabilityProvider<IMana>(MANA_CAPABILITY, DEFAULT_FACING, mana);
    }

    @Mod.EventBusSubscriber(modid="ars_nouveau")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof PlayerEntity) {
                Mana mana = new Mana((LivingEntity)event.getObject());
                event.addCapability(ID, ManaCapability.createProvider(mana));
            }
        }

        @SubscribeEvent
        public static void playerClone(PlayerEvent.Clone event) {
            ManaCapability.getMana((LivingEntity)event.getOriginal()).ifPresent(oldMaxMana -> ManaCapability.getMana((LivingEntity)event.getPlayer()).ifPresent(newMaxMana -> {
                newMaxMana.setMaxMana(oldMaxMana.getMaxMana());
                newMaxMana.setMana(oldMaxMana.getCurrentMana());
            }));
        }
    }
}

