/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.common.crafting.ModCrafting;
import com.hollingsworth.arsnouveau.common.crafting.recipes.RecipeUtil;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BookUpgradeRecipe
extends ShapelessRecipe {
    private BookUpgradeRecipe(ResourceLocation id, String group, ItemStack recipeOutput, NonNullList<Ingredient> ingredients) {
        super(id, group, recipeOutput, ingredients);
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        System.out.println("Book recipe");
        ItemStack output = super.func_77572_b(inv);
        if (!output.func_190926_b()) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack ingredient = inv.func_70301_a(i);
                if (ingredient.func_190926_b() || !(ingredient.func_77973_b() instanceof SpellBook)) continue;
                System.out.println(output);
                output.func_77982_d(ingredient.func_77978_p());
            }
        }
        return output;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModCrafting.Recipes.BOOK_UPGRADE_RECIPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<BookUpgradeRecipe> {
        public BookUpgradeRecipe read(ResourceLocation recipeID, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> ingredients = RecipeUtil.parseShapeless(json);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"), (boolean)true);
            return new BookUpgradeRecipe(recipeID, group, result, ingredients);
        }

        public BookUpgradeRecipe read(ResourceLocation recipeID, PacketBuffer buffer) {
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            int numIngredients = buffer.func_150792_a();
            NonNullList ingredients = NonNullList.func_191197_a((int)numIngredients, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack result = buffer.func_150791_c();
            return new BookUpgradeRecipe(recipeID, group, result, ingredients);
        }

        public void write(PacketBuffer buffer, BookUpgradeRecipe recipe) {
            buffer.func_180714_a(recipe.func_193358_e());
            buffer.func_150787_b(recipe.func_192400_c().size());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.func_77571_b());
        }
    }
}

