/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ModelFile;

public class BlockStatesDatagen
extends BlockStateProvider {
    public BlockStatesDatagen(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.registerNormalCube(BlockRegistry.ARCANE_STONE, "arcane_stone");
        this.registerNormalCube(BlockRegistry.ARCANE_BRICKS, "arcane_bricks");
        this.registerNormalCube(BlockRegistry.AB_ALTERNATE, "ab_alternating");
        this.registerNormalCube(BlockRegistry.AB_BASKET, "ab_basket");
        this.registerNormalCube(BlockRegistry.AB_HERRING, "ab_herring");
        this.registerNormalCube(BlockRegistry.AB_MOSAIC, "ab_mosaic");
    }

    public void registerNormalCube(Block block, String registry) {
        this.buildNormalCube(registry);
        this.simpleBlock(block, BlockStatesDatagen.getUncheckedModel(registry));
    }

    public static ModelFile getUncheckedModel(String registry) {
        return new ModelFile.UncheckedModelFile("ars_nouveau:block/" + registry);
    }

    protected void registerModels() {
        this.buildNormalCube("arcane_bricks");
        this.buildNormalCube("arcane_stone");
        this.buildNormalCube("ab_alternating");
        this.buildNormalCube("ab_basket");
        this.buildNormalCube("ab_herring");
        this.buildNormalCube("ab_mosaic");
    }

    public void buildNormalCube(String registryName) {
        ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(registryName)).parent((ModelFile)new ModelFile.UncheckedModelFile("block/cube_all"))).texture("all", this.getBlockLoc(registryName));
    }

    public ResourceLocation getBlockLoc(String registryName) {
        return new ResourceLocation("ars_nouveau", "blocks/" + registryName);
    }
}

