/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.common.collect.ImmutableList;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootParameterSet;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.ValidationTracker;

public class DefaultTableProvider
extends LootTableProvider {
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> tables = ImmutableList.of((Object)Pair.of(BlockLootTable::new, (Object)LootParameterSets.field_216267_h));

    public DefaultTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return this.tables;
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
        map.forEach((p_218436_2_, p_218436_3_) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)p_218436_2_, (LootTable)p_218436_3_));
    }

    public static class BlockLootTable
    extends BlockLootTables {
        public List<Block> list = new ArrayList<Block>();

        protected void addTables() {
            this.registerDropSelf(BlockRegistry.AB_ALTERNATE);
            this.registerDropSelf(BlockRegistry.ARCANE_BRICKS);
            this.registerDropSelf(BlockRegistry.ARCANE_PEDESTAL);
            this.registerDropSelf(BlockRegistry.ARCANE_STONE);
            this.registerDropSelf(BlockRegistry.AB_BASKET);
            this.registerDropSelf(BlockRegistry.AB_HERRING);
            this.registerDropSelf(BlockRegistry.AB_MOSAIC);
            this.registerDropSelf(BlockRegistry.WARD_BLOCK);
            this.registerDropSelf(BlockRegistry.SPELL_TURRET);
            this.registerDrop(BlockRegistry.ARCANE_ORE, (IItemProvider)ItemsRegistry.manaGem);
        }

        public void registerDropSelf(Block block) {
            this.list.add(block);
            this.func_218492_c(block);
        }

        public void registerDrop(Block input, IItemProvider output) {
            this.list.add(input);
            this.func_218493_a(input, output);
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.list;
        }
    }
}

