/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.common.base.Preconditions;
import com.hollingsworth.arsnouveau.common.datagen.BlockStatesDatagen;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
        super(generator, modid, existingFileHelper);
    }

    protected void registerModels() {
        ((ItemModelBuilder)this.getBuilder("glyph")).texture("layer0", this.itemTexture(ItemsRegistry.noviceSpellBook));
        ItemsRegistry.RegistrationHandler.ITEMS.forEach(i -> {
            if (i instanceof Glyph) {
                ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("glyph_" + ((Glyph)i).spellPart.getTag())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.spellTexture((Item)i));
            }
        });
        ((ItemModelBuilder)this.getBuilder("arcane_stone")).parent(BlockStatesDatagen.getUncheckedModel("arcane_stone"));
        ((ItemModelBuilder)this.getBuilder("ab_alternating")).parent(BlockStatesDatagen.getUncheckedModel("ab_alternating"));
        ((ItemModelBuilder)this.getBuilder("ab_basket")).parent(BlockStatesDatagen.getUncheckedModel("ab_basket"));
        ((ItemModelBuilder)this.getBuilder("ab_herring")).parent(BlockStatesDatagen.getUncheckedModel("ab_herring"));
        ((ItemModelBuilder)this.getBuilder("ab_mosaic")).parent(BlockStatesDatagen.getUncheckedModel("ab_mosaic"));
    }

    public String func_200397_b() {
        return "Ars Nouveau Item Models";
    }

    private ResourceLocation registryName(Item item) {
        return (ResourceLocation)Preconditions.checkNotNull((Object)item.getRegistryName(), (String)"Item %s has a null registry name", (Object)item);
    }

    private ResourceLocation itemTexture(Item item) {
        ResourceLocation name = this.registryName(item);
        return new ResourceLocation(name.func_110624_b(), "items/" + name.func_110623_a());
    }

    private ResourceLocation spellTexture(Item item) {
        ResourceLocation name = this.registryName(item);
        return new ResourceLocation(name.func_110624_b(), "items/" + name.func_110623_a().replace("glyph_", ""));
    }
}

