/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.IEnchantingRecipe;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.setup.APIRegistry;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpellDocProvider
implements IDataProvider {
    private final DataGenerator generator;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LogManager.getLogger();

    public SpellDocProvider(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        APIRegistry.registerApparatusRecipes();
        Path path = this.generator.func_200391_b();
        System.out.println("ACTING IN DOC PROVIDER");
        ArrayList<AbstractSpellPart> spells = new ArrayList<AbstractSpellPart>(ArsNouveauAPI.getInstance().getSpell_map().values());
        for (AbstractSpellPart spellPatchouliObj : spells) {
            Path path1 = SpellDocProvider.getSpellPath(path, spellPatchouliObj);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)spellPatchouliObj.serialize(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save spell {}", (Object)path1, (Object)ioexception);
            }
        }
        ArrayList<EnchantingApparatusRecipe> apparatusRecipes = new ArrayList<EnchantingApparatusRecipe>();
        for (IEnchantingRecipe iEnchantingRecipe : ArsNouveauAPI.getInstance().getEnchantingApparatusRecipes()) {
            if (!(iEnchantingRecipe instanceof EnchantingApparatusRecipe)) continue;
            apparatusRecipes.add((EnchantingApparatusRecipe)iEnchantingRecipe);
        }
        System.out.println(apparatusRecipes);
        for (EnchantingApparatusRecipe r : apparatusRecipes) {
            Path path1 = SpellDocProvider.getApparatusPath(path, r);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)r.serialize(), (Path)path1);
                System.out.println(r);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save apparatus {}", (Object)path1, (Object)ioexception);
            }
        }
    }

    private static Path getSpellPath(Path pathIn, AbstractSpellPart spell) {
        return pathIn.resolve("data/ars_nouveau/spells/" + spell.getTag() + ".json");
    }

    private static Path getApparatusPath(Path pathIn, EnchantingApparatusRecipe e) {
        return pathIn.resolve("data/ars_nouveau/apparatus/" + e.result.func_77973_b().getRegistryName().toString().replace("ars_nouveau:", "") + ".json");
    }

    public String func_200397_b() {
        return "Spell Documentation Patchouli Provider";
    }
}

