/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.PortUtil;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.goal.GoBackHomeGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.AvoidPlayerUntamedGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.FindItem;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StoreItemGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.TakeItemGoal;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib.animation.builder.AnimationBuilder;
import software.bernie.geckolib.animation.controller.EntityAnimationController;
import software.bernie.geckolib.entity.IAnimatedEntity;
import software.bernie.geckolib.event.AnimationTestEvent;
import software.bernie.geckolib.manager.EntityAnimationManager;

public class EntityCarbuncle
extends CreatureEntity
implements IAnimatedEntity,
IDispellable,
ITooltipProvider,
IWandable {
    public BlockPos fromPos;
    public BlockPos toPos;
    public List<ItemStack> allowedItems;
    public List<ItemStack> ignoreItems;
    public boolean whitelist;
    public boolean blacklist;
    public static final DataParameter<ItemStack> HELD_ITEM = EntityDataManager.func_187226_a(EntityCarbuncle.class, (IDataSerializer)DataSerializers.field_187196_f);
    public static final DataParameter<Boolean> TAMED = EntityDataManager.func_187226_a(EntityCarbuncle.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> HOP = EntityDataManager.func_187226_a(EntityCarbuncle.class, (IDataSerializer)DataSerializers.field_187198_h);
    public int backOff;
    public int tamingTime;
    EntityAnimationManager manager = new EntityAnimationManager();
    EntityAnimationController<EntityCarbuncle> walkController = new EntityAnimationController((Entity)this, "walkController", 20.0f, this::animationPredicate);
    EntityAnimationController<EntityCarbuncle> idleController = new EntityAnimationController((Entity)this, "idleController", 20.0f, this::idlePredicate);
    private boolean setBehaviors;

    public EntityCarbuncle(EntityType<EntityCarbuncle> entityCarbuncleEntityType, World world) {
        super(entityCarbuncleEntityType, world);
        this.setupAnimations();
        this.addGoalsAfterConstructor();
    }

    public EntityCarbuncle(World world, boolean tamed) {
        super(ModEntities.ENTITY_CARBUNCLE_TYPE, world);
        this.setTamed(tamed);
        this.setupAnimations();
        this.addGoalsAfterConstructor();
    }

    public void setupAnimations() {
        this.manager.addAnimationController(this.walkController);
        this.manager.addAnimationController(this.idleController);
    }

    private <E extends Entity> boolean idlePredicate(AnimationTestEvent<E> event) {
        if (this.field_70170_p.func_82737_E() % 20L == 0L && this.field_70170_p.field_73012_v.nextInt(3) == 0 && !((Boolean)this.field_70180_af.func_187225_a(HOP)).booleanValue()) {
            this.manager.setAnimationSpeed(3.0);
            this.idleController.setAnimation(new AnimationBuilder().addAnimation("idle"));
        }
        return true;
    }

    private <E extends Entity> boolean animationPredicate(AnimationTestEvent<E> event) {
        if (((Boolean)this.field_70180_af.func_187225_a(HOP)).booleanValue()) {
            this.manager.setAnimationSpeed(5.0);
            this.walkController.setAnimation(new AnimationBuilder().addAnimation("hop"));
            return true;
        }
        return false;
    }

    public EntityAnimationManager getAnimationManager() {
        return this.manager;
    }

    public boolean isTamed() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMED);
    }

    public void setTamed(boolean tamed) {
        this.field_70180_af.func_187227_b(TAMED, (Object)tamed);
    }

    public void attemptTame() {
        if (!this.isTamed() && this.getHeldStack().func_77973_b() == Items.field_151074_bl) {
            ++this.tamingTime;
            if (this.tamingTime % 20 == 0 && !this.field_70170_p.func_201670_d()) {
                Networking.sendToNearby(this.field_70170_p, (Entity)this, (Object)new PacketANEffect(PacketANEffect.EffectType.TIMED_HELIX, this.func_180425_c(), new int[0]));
            }
            if (this.tamingTime > 60 && !this.field_70170_p.field_72995_K) {
                ItemStack stack = new ItemStack((IItemProvider)ItemsRegistry.carbuncleShard, 1 + this.field_70170_p.field_73012_v.nextInt(2));
                this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), stack));
                this.remove(false);
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_193788_dg, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            } else if (this.tamingTime > 55 && this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 10; ++i) {
                    double d0 = this.func_226277_ct_();
                    double d1 = this.func_226278_cu_() + 0.1;
                    double d2 = this.func_226281_cx_();
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197624_q, d0, d1, d2, ((double)(this.field_70170_p.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(this.field_70170_p.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(this.field_70170_p.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0);
                }
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70699_by.func_75500_f()) {
                this.field_70180_af.func_187227_b(HOP, (Object)false);
            } else {
                this.field_70180_af.func_187227_b(HOP, (Object)true);
            }
        }
        if (this.backOff > 0 && !this.field_70170_p.field_72995_K) {
            --this.backOff;
        }
        if (this.field_70729_aU) {
            return;
        }
        if (this.getHeldStack().func_190926_b() && !this.field_70170_p.field_72995_K) {
            for (ItemEntity itementity : this.field_70170_p.func_217357_a(ItemEntity.class, this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0))) {
                if (itementity.field_70128_L || itementity.func_92059_d().func_190926_b() || itementity.func_174874_s()) continue;
                if (!this.isTamed() && itementity.func_92059_d().func_77973_b() != Items.field_151074_bl) {
                    return;
                }
                this.func_175445_a(itementity);
                this.field_70180_af.func_187227_b(HOP, (Object)false);
            }
        }
        this.attemptTame();
    }

    @Override
    public void onWanded(PlayerEntity playerEntity) {
    }

    @Override
    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, PlayerEntity playerEntity) {
        if (storedPos == null) {
            return;
        }
        if (this.field_70170_p.func_175625_s(storedPos) instanceof IInventory) {
            PortUtil.sendMessage(playerEntity, "Carbuncle will store items here.");
            this.toPos = storedPos;
        }
    }

    @Override
    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, PlayerEntity playerEntity) {
        if (storedPos == null) {
            return;
        }
        if (this.field_70170_p.func_175625_s(storedPos) instanceof IInventory) {
            PortUtil.sendMessage(playerEntity, "Carbuncle take from this inventory.");
            this.fromPos = storedPos;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 45) {
            ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (!itemstack.func_190926_b()) {
                for (int i = 0; i < 8; ++i) {
                    Vec3d vec3d = new Vec3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).func_178789_a(-this.field_70125_A * ((float)Math.PI / 180)).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                    this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, itemstack), this.func_226277_ct_() + this.func_70040_Z().field_72450_a / 2.0, this.func_226278_cu_(), this.func_226281_cx_() + this.func_70040_Z().field_72449_c / 2.0, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c);
                }
            }
        } else {
            super.func_70103_a(id);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        if (this.getHeldStack().func_190926_b() && TakeItemGoal.isValidItem(this, itemEntity.func_92059_d())) {
            this.setHeldStack(itemEntity.func_92059_d());
            itemEntity.func_70106_y();
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187638_cR, this.func_184176_by(), 1.0f, 1.0f);
        }
    }

    protected void addGoalsAfterConstructor() {
        if (this.field_70170_p.func_201670_d()) {
            return;
        }
        for (PrioritizedGoal goal : this.getGoals()) {
            this.field_70714_bg.func_75776_a(goal.func_220770_h(), goal.func_220772_j());
        }
    }

    public List<PrioritizedGoal> getGoals() {
        return Boolean.TRUE.equals(this.field_70180_af.func_187225_a(TAMED)) ? this.getTamedGoals() : this.getUntamedGoals();
    }

    protected void func_184651_r() {
    }

    public BlockPos getHome() {
        if (this.fromPos == null && this.toPos != null) {
            return this.toPos;
        }
        if (this.toPos == null && this.fromPos != null) {
            return this.fromPos;
        }
        if (this.toPos != null) {
            return this.fromPos;
        }
        return null;
    }

    public List<PrioritizedGoal> getTamedGoals() {
        ArrayList<PrioritizedGoal> list = new ArrayList<PrioritizedGoal>();
        list.add(new PrioritizedGoal(2, (Goal)new FindItem(this)));
        list.add(new PrioritizedGoal(3, (Goal)new StoreItemGoal(this)));
        list.add(new PrioritizedGoal(3, (Goal)new TakeItemGoal(this)));
        list.add(new PrioritizedGoal(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 0.02f)));
        list.add(new PrioritizedGoal(5, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f)));
        list.add(new PrioritizedGoal(0, (Goal)new SwimGoal((MobEntity)this)));
        list.add(new PrioritizedGoal(1, (Goal)new GoBackHomeGoal((MobEntity)this, this::getHome, 25, () -> this.getHeldStack() == null || this.getHeldStack().func_190926_b())));
        return list;
    }

    public List<PrioritizedGoal> getUntamedGoals() {
        ArrayList<PrioritizedGoal> list = new ArrayList<PrioritizedGoal>();
        list.add(new PrioritizedGoal(1, (Goal)new FindItem(this)));
        list.add(new PrioritizedGoal(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 0.02f)));
        list.add(new PrioritizedGoal(4, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f)));
        list.add(new PrioritizedGoal(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0)));
        list.add(new PrioritizedGoal(2, (Goal)new AvoidPlayerUntamedGoal(this, PlayerEntity.class, 16.0f, 1.6, 1.4)));
        list.add(new PrioritizedGoal(0, (Goal)new SwimGoal((MobEntity)this)));
        return list;
    }

    public void func_70645_a(DamageSource source) {
        if (!this.field_70170_p.field_72995_K && this.isTamed()) {
            ItemStack stack = new ItemStack((IItemProvider)ItemsRegistry.carbuncleCharm);
            this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack));
            if (this.getHeldStack() != null) {
                this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.getHeldStack()));
            }
        }
        super.func_70645_a(source);
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        List<ItemStack> items;
        if (hand != Hand.MAIN_HAND || player.func_130014_f_().field_72995_K) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!(stack.func_77973_b() instanceof ItemScroll) || !stack.func_77942_o()) {
            return false;
        }
        if (stack.func_77973_b() == ItemsRegistry.ALLOW_ITEM_SCROLL) {
            List<ItemStack> items2 = ItemsRegistry.ALLOW_ITEM_SCROLL.getItems(stack);
            if (!items2.isEmpty()) {
                this.allowedItems = ItemsRegistry.ALLOW_ITEM_SCROLL.getItems(stack);
                this.whitelist = true;
                this.blacklist = false;
                PortUtil.sendMessage(player, (ITextComponent)new TranslationTextComponent("ars_nouveau.allow_set", new Object[0]));
            }
            return true;
        }
        if (stack.func_77973_b() == ItemsRegistry.DENY_ITEM_SCROLL && !(items = ItemsRegistry.DENY_ITEM_SCROLL.getItems(stack)).isEmpty()) {
            this.ignoreItems = ItemsRegistry.DENY_ITEM_SCROLL.getItems(stack);
            this.whitelist = false;
            this.blacklist = true;
            PortUtil.sendMessage(player, (ITextComponent)new TranslationTextComponent("ars_nouveau.ignore_set", new Object[0]));
        }
        return true;
    }

    public EntityType<?> func_200600_R() {
        return ModEntities.ENTITY_CARBUNCLE_TYPE;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HELD_ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(TAMED, (Object)false);
        this.field_70180_af.func_187214_a(HOP, (Object)false);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("held")) {
            this.setHeldStack(ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)tag.func_74781_a("held"))));
        }
        this.toPos = NBTUtil.getBlockPos(tag, "to");
        this.fromPos = NBTUtil.getBlockPos(tag, "from");
        this.backOff = tag.func_74762_e("backoff");
        this.tamingTime = tag.func_74762_e("taming_time");
        this.whitelist = tag.func_74767_n("whitelist");
        this.blacklist = tag.func_74767_n("blacklist");
        this.field_70180_af.func_187227_b(HOP, (Object)tag.func_74767_n("hop"));
        if (!this.setBehaviors) {
            this.removeGoals();
        }
        this.field_70180_af.func_187227_b(TAMED, (Object)tag.func_74767_n("tamed"));
        if (!this.setBehaviors) {
            this.addGoalsAfterConstructor();
            this.setBehaviors = true;
        }
        this.allowedItems = NBTUtil.readItems(tag, "allowed_");
        this.ignoreItems = NBTUtil.readItems(tag, "ignored_");
    }

    public void setHeldStack(ItemStack stack) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, stack);
    }

    public ItemStack getHeldStack() {
        return this.func_184614_ca();
    }

    @Override
    public boolean onDispel(@Nullable LivingEntity caster) {
        if (this.field_70128_L) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.isTamed()) {
            ItemStack stack = new ItemStack((IItemProvider)ItemsRegistry.carbuncleCharm);
            this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack.func_77946_l()));
            stack = this.getHeldStack();
            this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack));
            ParticleUtil.spawnPoof((ServerWorld)this.field_70170_p, this.func_180425_c());
            this.func_70106_y();
        }
        return this.isTamed();
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        if (this.getHeldStack() != null) {
            CompoundNBT itemTag = new CompoundNBT();
            this.getHeldStack().func_77955_b(itemTag);
            tag.func_218657_a("held", (INBT)itemTag);
        }
        if (this.toPos != null) {
            NBTUtil.storeBlockPos(tag, "to", this.toPos);
        }
        if (this.fromPos != null) {
            NBTUtil.storeBlockPos(tag, "from", this.fromPos);
        }
        tag.func_74768_a("backoff", this.backOff);
        tag.func_74757_a("tamed", ((Boolean)this.field_70180_af.func_187225_a(TAMED)).booleanValue());
        tag.func_74768_a("taming_time", this.tamingTime);
        tag.func_74757_a("hop", ((Boolean)this.field_70180_af.func_187225_a(HOP)).booleanValue());
        tag.func_74757_a("whitelist", this.whitelist);
        tag.func_74757_a("blacklist", this.blacklist);
        if (this.allowedItems != null && !this.allowedItems.isEmpty()) {
            NBTUtil.writeItems(tag, "allowed_", this.allowedItems);
        }
        if (this.ignoreItems != null && !this.ignoreItems.isEmpty()) {
            NBTUtil.writeItems(tag, "ignored_", this.ignoreItems);
        }
    }

    public void removeGoals() {
        this.field_70714_bg.field_220892_d = new LinkedHashSet();
    }

    @Override
    public List<String> getTooltip() {
        return new ArrayList<String>();
    }
}

