/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.event.ProcessOreEvent;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketEntityAnimationSync;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib.animation.builder.AnimationBuilder;
import software.bernie.geckolib.animation.controller.EntityAnimationController;
import software.bernie.geckolib.entity.IAnimatedEntity;
import software.bernie.geckolib.event.AnimationTestEvent;
import software.bernie.geckolib.manager.EntityAnimationManager;

public class EntityEarthElemental
extends CreatureEntity
implements IAnimatedEntity {
    EntityAnimationManager manager = new EntityAnimationManager();
    EntityAnimationController<EntityEarthElemental> smeltController = new EntityAnimationController((Entity)this, "smeltController", 20.0f, this::smeltPredicate);
    EntityAnimationController<EntityEarthElemental> idleController = new EntityAnimationController((Entity)this, "idleController", 20.0f, this::idlePredicate);

    private <E extends Entity> boolean smeltPredicate(AnimationTestEvent<E> event) {
        return true;
    }

    private <E extends Entity> boolean idlePredicate(AnimationTestEvent<E> event) {
        if (!this.getHeldStack().func_190926_b()) {
            return true;
        }
        this.manager.setAnimationSpeed(1.0);
        this.idleController.setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
        return true;
    }

    protected EntityEarthElemental(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.registerControllers();
    }

    public EntityEarthElemental(World world) {
        this(ModEntities.ENTITY_EARTH_ELEMENTAL_TYPE, world);
    }

    public void registerControllers() {
        this.manager.addAnimationController(this.smeltController);
        this.manager.addAnimationController(this.idleController);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        System.out.println(this.func_145782_y());
        if (player.func_130014_f_().field_72995_K) {
            System.out.println(this.manager.get((Object)"idleController"));
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getHeldStack().func_190926_b() && !this.field_70170_p.field_72995_K) {
            for (ItemEntity itementity : this.field_70170_p.func_217357_a(ItemEntity.class, this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0))) {
                if (itementity.field_70128_L || itementity.func_92059_d().func_190926_b() || itementity.func_174874_s()) continue;
                this.func_175445_a(itementity);
                System.out.println("sending packet");
                Networking.sendToNearby(this.field_70170_p, (Entity)this, (Object)new PacketEntityAnimationSync(this.func_145782_y(), "smeltController", "smelting"));
                EventQueue.getInstance().addEvent(new ProcessOreEvent(this, 400));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 45) {
            ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (!itemstack.func_190926_b()) {
                for (int i = 0; i < 8; ++i) {
                    Vec3d vec3d = new Vec3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).func_178789_a(-this.field_70125_A * ((float)Math.PI / 180)).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                    this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, itemstack), this.func_226277_ct_() + this.func_70040_Z().field_72450_a / 2.0, this.func_226278_cu_(), this.func_226281_cx_() + this.func_70040_Z().field_72449_c / 2.0, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c);
                }
            }
        } else {
            super.func_70103_a(id);
        }
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        if (this.getHeldStack().func_190926_b()) {
            this.setHeldStack(itemEntity.func_92059_d());
            itemEntity.func_70106_y();
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187638_cR, this.func_184176_by(), 1.0f, 1.0f);
        }
    }

    public void setHeldStack(ItemStack stack) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, stack);
    }

    public ItemStack getHeldStack() {
        return this.func_184614_ca();
    }

    public EntityAnimationManager getAnimationManager() {
        return this.manager;
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        if (this.getHeldStack() != null) {
            CompoundNBT itemTag = new CompoundNBT();
            this.getHeldStack().func_77955_b(itemTag);
            tag.func_218657_a("held", (INBT)itemTag);
        }
    }

    public void func_70020_e(CompoundNBT tag) {
        super.func_70020_e(tag);
        if (tag.func_74764_b("held")) {
            this.setHeldStack(ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)tag.func_74781_a("held"))));
        }
    }
}

