/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityProjectileSpell
extends ArrowEntity {
    private int age;
    private SpellResolver spellResolver;
    public int xpColor;
    public int pierceLeft;

    public EntityProjectileSpell(EntityType<? extends ArrowEntity> type, World worldIn, SpellResolver spellResolver, int pierceLeft) {
        super(type, worldIn);
        this.spellResolver = spellResolver;
        this.age = 0;
        this.pierceLeft = pierceLeft;
    }

    public EntityProjectileSpell(EntityType<? extends EntityProjectileSpell> entityType, World world) {
        super(entityType, world);
    }

    public EntityProjectileSpell(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityProjectileSpell(World world, LivingEntity shooter, SpellResolver spellResolver, int maxPierce) {
        super(world, shooter);
        this.spellResolver = spellResolver;
        this.age = 0;
        this.pierceLeft = maxPierce;
    }

    public EntityProjectileSpell(World world, LivingEntity shooter) {
        super(world, shooter);
    }

    public void func_70071_h_() {
        ++this.age;
        if (this.age > 3600) {
            this.func_70106_y();
            return;
        }
        this.field_70142_S = this.func_226277_ct_();
        this.field_70137_T = this.func_226278_cu_();
        this.field_70136_U = this.func_226281_cx_();
        if (this.field_70254_i) {
            this.field_70254_i = false;
            this.func_213317_d(this.func_213322_ci().func_216372_d((double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f)));
        }
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0);
        for (Entity entity : this.field_70170_p.func_175674_a((Entity)this, axisalignedbb, p_213881_0_ -> !p_213881_0_.func_175149_v() && p_213881_0_.func_70067_L())) {
        }
        RayTraceResult raytraceresult = ProjectileHelper.func_221267_a((Entity)this, (AxisAlignedBB)axisalignedbb, p_213880_1_ -> !p_213880_1_.func_175149_v() && p_213880_1_.func_70067_L(), (RayTraceContext.BlockMode)RayTraceContext.BlockMode.OUTLINE, (boolean)true);
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(((BlockRayTraceResult)raytraceresult).func_216350_a()).func_177230_c() == Blocks.field_150427_aO) {
                this.func_181015_d(((BlockRayTraceResult)raytraceresult).func_216350_a());
            } else if (!ForgeEventFactory.onProjectileImpact((AbstractArrowEntity)this, (RayTraceResult)raytraceresult)) {
                this.func_184549_a(raytraceresult);
            }
        }
        Vec3d vec3d = this.func_213322_ci();
        double x = this.func_226277_ct_() + vec3d.field_72450_a;
        double y = this.func_226278_cu_() + vec3d.field_72448_b;
        double z = this.func_226281_cx_() + vec3d.func_82616_c();
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
        if (!this.func_189652_ae()) {
            Vec3d vec3d1 = this.func_213322_ci();
            this.func_213293_j(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c);
        }
        this.func_70107_b(x, y, z);
        if (this.field_70170_p.field_72995_K && this.age > 1) {
            double deltaX = this.func_226277_ct_() - this.field_70142_S;
            double deltaY = this.func_226278_cu_() - this.field_70137_T;
            double deltaZ = this.func_226281_cx_() - this.field_70136_U;
            double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 20.0);
            int counter = 0;
            for (double i = 0.0; i < dist; i += 1.0) {
                double coeff = i / dist;
                if ((counter += this.field_70170_p.field_73012_v.nextInt(3)) % (Minecraft.func_71410_x().field_71474_y.field_74362_aa.func_216832_b() == 0 ? 1 : 2 * Minecraft.func_71410_x().field_71474_y.field_74362_aa.func_216832_b()) != 0) continue;
                this.field_70170_p.func_195594_a(GlowParticleData.createData(new ParticleColor(255, 25, 180)), (double)((float)(this.field_70169_q + deltaX * coeff)), (double)((float)(this.field_70167_r + deltaY * coeff)), (double)((float)(this.field_70166_s + deltaZ * coeff)), (double)(0.0125f * (this.field_70146_Z.nextFloat() - 0.5f)), (double)(0.0125f * (this.field_70146_Z.nextFloat() - 0.5f)), (double)(0.0125f * (this.field_70146_Z.nextFloat() - 0.5f)));
            }
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
    }

    public void func_184547_a(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        Vec3d vec3d = entityThrower.func_70040_Z();
        this.func_213317_d(this.func_213322_ci().func_72441_c(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c));
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3d vec3d = new Vec3d(x, y, z).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy).func_186678_a((double)velocity);
        this.func_213317_d(vec3d);
        float f = MathHelper.func_76133_a((double)EntityProjectileSpell.func_213296_b((Vec3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public boolean func_189652_ae() {
        return true;
    }

    public EntityType<?> func_200600_R() {
        return ModEntities.SPELL_PROJ;
    }

    protected void attemptRemoval() {
        --this.pierceLeft;
        if (this.pierceLeft < 0) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
    }

    protected void func_184549_a(RayTraceResult result) {
        if (this.field_70128_L) {
            return;
        }
        if (!this.field_70170_p.field_72995_K && result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            if (((EntityRayTraceResult)result).func_216348_a().equals((Object)this.func_212360_k())) {
                return;
            }
            if (this.spellResolver != null) {
                this.spellResolver.onResolveEffect(this.field_70170_p, (LivingEntity)this.func_212360_k(), result);
                Networking.sendToNearby(this.field_70170_p, new BlockPos(result.func_216347_e()), (Object)new PacketANEffect(PacketANEffect.EffectType.BURST, new BlockPos(result.func_216347_e()), new int[0]));
                this.attemptRemoval();
            }
        }
        if (!this.field_70170_p.field_72995_K && result instanceof BlockRayTraceResult) {
            BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)result;
            BlockState state = this.field_70170_p.func_180495_p(((BlockRayTraceResult)result).func_216350_a());
            if (state.func_185904_a() == Material.field_151567_E) {
                state.func_177230_c().func_196262_a(state, this.field_70170_p, ((BlockRayTraceResult)result).func_216350_a(), (Entity)this);
                return;
            }
            if (state.func_196957_g((IBlockReader)this.field_70170_p, blockraytraceresult.func_216350_a(), PathType.AIR)) {
                return;
            }
            if (this.spellResolver != null) {
                this.spellResolver.onResolveEffect(this.field_70170_p, (LivingEntity)this.func_212360_k(), (RayTraceResult)blockraytraceresult);
            }
            Networking.sendToNearby(this.field_70170_p, ((BlockRayTraceResult)result).func_216350_a(), (Object)new PacketANEffect(PacketANEffect.EffectType.BURST, new BlockPos(result.func_216347_e()).func_177977_b(), new int[0]));
            this.attemptRemoval();
        }
    }

    public EntityProjectileSpell(FMLPlayMessages.SpawnEntity packet, World world) {
        super(ModEntities.SPELL_PROJ, world);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("pierce")) {
            this.pierceLeft = tag.func_74762_e("pierce");
        }
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74768_a("pierce", this.pierceLeft);
    }
}

