/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.spell.IPickupResponder;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.PortUtil;
import com.hollingsworth.arsnouveau.common.block.tile.SummoningCrytalTile;
import com.hollingsworth.arsnouveau.common.entity.AbstractFlyingCreature;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.goal.GoBackHomeGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.sylph.BonemealGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.sylph.EvaluateGroveGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.sylph.FollowPlayerGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.sylph.GenerateDropsGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.sylph.InspectPlantGoal;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import software.bernie.geckolib.animation.builder.AnimationBuilder;
import software.bernie.geckolib.animation.controller.EntityAnimationController;
import software.bernie.geckolib.entity.IAnimatedEntity;
import software.bernie.geckolib.event.AnimationTestEvent;
import software.bernie.geckolib.manager.EntityAnimationManager;

public class EntitySylph
extends AbstractFlyingCreature
implements IPickupResponder,
IAnimatedEntity,
ITooltipProvider,
IDispellable {
    EntityAnimationManager manager = new EntityAnimationManager();
    EntityAnimationController<EntitySylph> idleController = new EntityAnimationController((Entity)this, "idleController", 20.0f, this::idlePredicate);
    public int timeSinceBonemeal = 0;
    public static final DataParameter<Boolean> TAMED = EntityDataManager.func_187226_a(EntitySylph.class, (IDataSerializer)DataSerializers.field_187198_h);
    public int tamingTime = 0;
    public boolean droppingShards;
    public static final DataParameter<Integer> MOOD_SCORE = EntityDataManager.func_187226_a(EntitySylph.class, (IDataSerializer)DataSerializers.field_187192_b);
    public int timeUntilGather = 0;
    public int timeUntilEvaluation = 0;
    public int diversityScore;
    public Map<BlockState, Integer> genTable;
    public Map<BlockState, Integer> scoreMap;
    public BlockPos crystalPos;
    public List<ItemStack> drops;
    private boolean setBehaviors;

    private <E extends Entity> boolean idlePredicate(AnimationTestEvent<E> event) {
        this.manager.setAnimationSpeed(1.0);
        this.idleController.setAnimation(new AnimationBuilder().addAnimation("idle"));
        return true;
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (hand != Hand.MAIN_HAND || player.func_130014_f_().field_72995_K) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b()) {
            int moodScore = (Integer)this.field_70180_af.func_187225_a(MOOD_SCORE);
            if (moodScore < 250) {
                PortUtil.sendMessage(player, (ITextComponent)new TranslationTextComponent("sylph.unhappy", new Object[0]));
            } else if (moodScore <= 500) {
                PortUtil.sendMessage(player, (ITextComponent)new TranslationTextComponent("sylph.content", new Object[0]));
            } else if (moodScore <= 750) {
                PortUtil.sendMessage(player, (ITextComponent)new TranslationTextComponent("sylph.happy", new Object[0]));
            } else if (moodScore < 1000) {
                PortUtil.sendMessage(player, (ITextComponent)new TranslationTextComponent("sylph.very_happy", new Object[0]));
            } else {
                PortUtil.sendMessage(player, (ITextComponent)new TranslationTextComponent("sylph.extremely_happy", new Object[0]));
            }
            int numDrops = this.diversityScore / 2;
            if (numDrops <= 5) {
                PortUtil.sendMessage(player, (ITextComponent)new TranslationTextComponent("sylph.okay_diversity", new Object[0]));
            } else if (numDrops <= 10) {
                PortUtil.sendMessage(player, (ITextComponent)new TranslationTextComponent("sylph.diverse_enough", new Object[0]));
            } else if (numDrops <= 20) {
                PortUtil.sendMessage(player, (ITextComponent)new TranslationTextComponent("sylph.very_diverse", new Object[0]));
            } else {
                PortUtil.sendMessage(player, (ITextComponent)new TranslationTextComponent("sylph.extremely_diverse", new Object[0]));
            }
            return true;
        }
        if (!(stack.func_77973_b() instanceof BlockItem)) {
            return true;
        }
        BlockState state = ((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P();
        int score = EvaluateGroveGoal.getScore(state);
        if (score > 0 && this.scoreMap != null && this.scoreMap.get(state) != null && this.scoreMap.get(state) >= 50) {
            PortUtil.sendMessage(player, (ITextComponent)new TranslationTextComponent("sylph.toomuch", new Object[0]));
            return true;
        }
        if (score == 0) {
            PortUtil.sendMessage(player, (ITextComponent)new TranslationTextComponent("sylph.notinterested", new Object[0]));
        }
        if (score == 1) {
            PortUtil.sendMessage(player, (ITextComponent)new TranslationTextComponent("sylph.likes", new Object[0]));
        }
        if (score == 2) {
            PortUtil.sendMessage(player, (ITextComponent)new TranslationTextComponent("sylph.excited", new Object[0]));
        }
        return super.func_184645_a(player, hand);
    }

    protected EntitySylph(EntityType<? extends AbstractFlyingCreature> type, World worldIn) {
        super(type, worldIn);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 10, true);
        this.setupAnimations();
        this.addGoalsAfterConstructor();
    }

    public EntitySylph(World world, boolean isTamed, BlockPos pos) {
        super(ModEntities.ENTITY_SYLPH_TYPE, world);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 10, true);
        this.field_70180_af.func_187227_b(TAMED, (Object)isTamed);
        this.crystalPos = pos;
        this.setupAnimations();
        this.addGoalsAfterConstructor();
    }

    public void setupAnimations() {
        this.manager.addAnimationController(this.idleController);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (Boolean.TRUE.equals(this.field_70180_af.func_187225_a(TAMED))) {
                --this.timeUntilEvaluation;
                --this.timeUntilGather;
            }
            ++this.timeSinceBonemeal;
        }
        if (this.droppingShards) {
            ++this.tamingTime;
            if (this.tamingTime % 20 == 0 && !this.field_70170_p.func_201670_d()) {
                Networking.sendToNearby(this.field_70170_p, (Entity)this, (Object)new PacketANEffect(PacketANEffect.EffectType.TIMED_HELIX, this.func_180425_c(), new int[0]));
            }
            if (this.tamingTime > 60 && !this.field_70170_p.field_72995_K) {
                ItemStack stack = new ItemStack((IItemProvider)ItemsRegistry.sylphShard, 1 + this.field_70170_p.field_73012_v.nextInt(1));
                this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), stack));
                this.remove(false);
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_193788_dg, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            } else if (this.tamingTime > 55 && this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 10; ++i) {
                    double d0 = this.func_226277_ct_();
                    double d1 = this.func_226278_cu_() + 0.1;
                    double d2 = this.func_226281_cx_();
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197624_q, d0, d1, d2, ((double)(this.field_70170_p.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(this.field_70170_p.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(this.field_70170_p.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0);
                }
            }
        }
    }

    protected void addGoalsAfterConstructor() {
        if (this.field_70170_p.func_201670_d()) {
            return;
        }
        for (PrioritizedGoal goal : this.getGoals()) {
            this.field_70714_bg.func_75776_a(goal.func_220770_h(), goal.func_220772_j());
        }
    }

    public List<PrioritizedGoal> getGoals() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMED) != false ? this.getTamedGoals() : this.getUntamedGoals();
    }

    public boolean enoughManaForTask() {
        if (!(this.field_70170_p.func_175625_s(this.crystalPos) instanceof SummoningCrytalTile)) {
            return false;
        }
        return ((SummoningCrytalTile)this.field_70170_p.func_175625_s(this.crystalPos)).enoughMana(250);
    }

    public boolean removeManaForDrops() {
        if (!(this.field_70170_p.func_175625_s(this.crystalPos) instanceof SummoningCrytalTile)) {
            return false;
        }
        return ((SummoningCrytalTile)this.field_70170_p.func_175625_s(this.crystalPos)).removeManaAround(250);
    }

    public boolean isTamed() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMED);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76367_g || source == DamageSource.field_220302_v) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70645_a(DamageSource source) {
        if (!this.field_70170_p.field_72995_K && this.isTamed()) {
            ItemStack stack = new ItemStack((IItemProvider)ItemsRegistry.sylphCharm);
            this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack));
        }
        super.func_70645_a(source);
    }

    public List<PrioritizedGoal> getTamedGoals() {
        ArrayList<PrioritizedGoal> list = new ArrayList<PrioritizedGoal>();
        list.add(new PrioritizedGoal(3, (Goal)new LookRandomlyGoal((MobEntity)this)));
        list.add(new PrioritizedGoal(2, (Goal)new BonemealGoal(this, () -> this.crystalPos, 10)));
        list.add(new PrioritizedGoal(1, (Goal)new EvaluateGroveGoal(this, 2400)));
        list.add(new PrioritizedGoal(2, (Goal)new InspectPlantGoal((MobEntity)this, () -> this.crystalPos, 15)));
        list.add(new PrioritizedGoal(1, (Goal)new GoBackHomeGoal((MobEntity)this, () -> this.crystalPos, 20)));
        list.add(new PrioritizedGoal(1, (Goal)new GenerateDropsGoal(this)));
        return list;
    }

    public List<PrioritizedGoal> getUntamedGoals() {
        ArrayList<PrioritizedGoal> list = new ArrayList<PrioritizedGoal>();
        list.add(new PrioritizedGoal(3, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 3.0f, 7.0f)));
        list.add(new PrioritizedGoal(5, (Goal)new FollowPlayerGoal((MobEntity)this, 1.0, 3.0f, 7.0f)));
        list.add(new PrioritizedGoal(2, (Goal)new LookRandomlyGoal((MobEntity)this)));
        list.add(new PrioritizedGoal(2, (Goal)new WaterAvoidingRandomFlyingGoal((CreatureEntity)this, 1.0)));
        list.add(new PrioritizedGoal(1, (Goal)new BonemealGoal(this)));
        return list;
    }

    @SubscribeEvent
    public void treeGrow(SaplingGrowTreeEvent event) {
        if (!((Boolean)this.field_70180_af.func_187225_a(TAMED)).booleanValue() && BlockUtil.distanceFrom(this.func_180425_c(), event.getPos()) <= 10.0) {
            this.droppingShards = true;
        }
    }

    protected void func_184651_r() {
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> tooltip = new ArrayList<String>();
        if (!((Boolean)this.field_70180_af.func_187225_a(TAMED)).booleanValue()) {
            return tooltip;
        }
        int mood = (Integer)this.field_70180_af.func_187225_a(MOOD_SCORE);
        String moodStr = "Very unhappy";
        if (mood >= 1000) {
            moodStr = "Extremely happy";
        } else if (mood >= 750) {
            moodStr = "Very happy";
        } else if (mood >= 500) {
            moodStr = "Happy";
        } else if (mood >= 250) {
            moodStr = "Content";
        }
        tooltip.add("Mood: " + moodStr);
        return tooltip;
    }

    @Override
    public ItemStack onPickup(ItemStack stack) {
        SummoningCrytalTile tile = this.field_70170_p.func_175625_s(this.crystalPos) instanceof SummoningCrytalTile ? (SummoningCrytalTile)this.field_70170_p.func_175625_s(this.crystalPos) : null;
        return tile == null ? stack : tile.insertItem(stack);
    }

    public EntityAnimationManager getAnimationManager() {
        return this.manager;
    }

    public boolean func_213397_c(double p_213397_1_) {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a((double)0.4f);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
    }

    protected PathNavigator func_175447_b(World world) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, world);
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(true);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("summoner_x")) {
            this.crystalPos = new BlockPos(tag.func_74762_e("summoner_x"), tag.func_74762_e("summoner_y"), tag.func_74762_e("summoner_z"));
        }
        this.timeSinceBonemeal = tag.func_74762_e("bonemeal");
        this.timeUntilGather = tag.func_74762_e("gather");
        this.timeUntilEvaluation = tag.func_74762_e("eval");
        this.field_70180_af.func_187227_b(TAMED, (Object)tag.func_74767_n("tamed"));
        this.field_70180_af.func_187227_b(MOOD_SCORE, (Object)tag.func_74762_e("score"));
        if (!this.setBehaviors) {
            this.tryResetGoals();
            this.setBehaviors = true;
        }
    }

    public void tryResetGoals() {
        this.field_70714_bg.field_220892_d = new LinkedHashSet();
        this.addGoalsAfterConstructor();
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        if (this.crystalPos != null) {
            tag.func_74768_a("summoner_x", this.crystalPos.func_177958_n());
            tag.func_74768_a("summoner_y", this.crystalPos.func_177956_o());
            tag.func_74768_a("summoner_z", this.crystalPos.func_177952_p());
        }
        tag.func_74768_a("eval", this.timeUntilEvaluation);
        tag.func_74768_a("bonemeal", this.timeSinceBonemeal);
        tag.func_74768_a("gather", this.timeUntilGather);
        tag.func_74757_a("tamed", ((Boolean)this.field_70180_af.func_187225_a(TAMED)).booleanValue());
        tag.func_74768_a("score", ((Integer)this.field_70180_af.func_187225_a(MOOD_SCORE)).intValue());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MOOD_SCORE, (Object)0);
        this.field_70180_af.func_187214_a(TAMED, (Object)false);
    }

    @Override
    public boolean onDispel(@Nullable LivingEntity caster) {
        if (this.field_70128_L) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.isTamed()) {
            ItemStack stack = new ItemStack((IItemProvider)ItemsRegistry.sylphCharm);
            this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack));
            ParticleUtil.spawnPoof((ServerWorld)this.field_70170_p, this.func_180425_c());
            this.func_70106_y();
        }
        return this.isTamed();
    }
}

