/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.IPickupResponder;
import com.hollingsworth.arsnouveau.api.spell.IPlaceBlockResponder;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.SpellRecipeUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.PortUtil;
import com.hollingsworth.arsnouveau.common.block.tile.SummoningCrytalTile;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.goal.whelp.PerformTaskGoal;
import com.hollingsworth.arsnouveau.common.items.DominionWand;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayerFactory;

public class EntityWhelp
extends FlyingEntity
implements IPickupResponder,
IPlaceBlockResponder,
IDispellable,
ITooltipProvider,
IWandable {
    public static final DataParameter<String> SPELL_STRING = EntityDataManager.func_187226_a(EntityWhelp.class, (IDataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<ItemStack> HELD_ITEM = EntityDataManager.func_187226_a(EntityWhelp.class, (IDataSerializer)DataSerializers.field_187196_f);
    public static final DataParameter<Boolean> STRICT_MODE = EntityDataManager.func_187226_a(EntityWhelp.class, (IDataSerializer)DataSerializers.field_187198_h);
    public BlockPos crystalPos;
    public int ticksSinceLastSpell;
    public List<AbstractSpellPart> spellRecipe;

    public boolean func_213397_c(double distanceFromPlayer) {
        return false;
    }

    protected EntityWhelp(EntityType<? extends FlyingEntity> p_i48568_1_, World world) {
        super(p_i48568_1_, world);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 10, true);
    }

    public EntityWhelp setRecipe(List<AbstractSpellPart> recipe) {
        this.spellRecipe = recipe;
        return this;
    }

    public EntityWhelp(World world) {
        super(ModEntities.ENTITY_WHELP_TYPE, world);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 10, true);
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (this.field_70170_p.field_72995_K || hand != Hand.MAIN_HAND) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof DominionWand) {
            return false;
        }
        if (stack != ItemStack.field_190927_a && stack.func_77973_b() instanceof SpellParchment) {
            ArrayList<AbstractSpellPart> spellParts = SpellParchment.getSpellRecipe(stack);
            if (new EntitySpellResolver(spellParts, new SpellContext(spellParts, (LivingEntity)this)).canCast((LivingEntity)this)) {
                this.spellRecipe = SpellParchment.getSpellRecipe(stack);
                this.setRecipeString(SpellRecipeUtil.serializeForNBT(this.spellRecipe));
                player.func_145747_a((ITextComponent)new StringTextComponent("Spell set."));
                return true;
            }
            player.func_145747_a((ITextComponent)new StringTextComponent("A whelp cannot cast an invalid spell."));
            return false;
        }
        if (stack == ItemStack.field_190927_a) {
            if (this.spellRecipe == null || this.spellRecipe.isEmpty()) {
                player.func_145747_a((ITextComponent)new StringTextComponent("Give this whelp a spell by giving it some inscribed Spell Parchment. "));
            } else {
                player.func_145747_a((ITextComponent)new StringTextComponent("This whelp is casting " + SpellRecipeUtil.getDisplayString(this.spellRecipe)));
            }
            return true;
        }
        this.setHeldStack(new ItemStack((IItemProvider)stack.func_77973_b()));
        player.func_145747_a((ITextComponent)new StringTextComponent("This whelp will use " + stack.func_77973_b().func_200295_i(stack).func_150254_d() + " in spells if this item is in a Summoning Crystal chest."));
        return true;
    }

    @Override
    public void onWanded(PlayerEntity playerEntity) {
        this.field_70180_af.func_187227_b(STRICT_MODE, (Object)((Boolean)this.field_70180_af.func_187225_a(STRICT_MODE) == false ? 1 : 0));
        PortUtil.sendMessage(playerEntity, (ITextComponent)new TranslationTextComponent("ars_nouveau.whelp.strict_mode", new Object[]{this.field_70180_af.func_187225_a(STRICT_MODE)}));
    }

    public EntityWhelp(World world, BlockPos crystalPos) {
        this(world);
        this.crystalPos = crystalPos;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p == null || this.field_70729_aU || this.crystalPos == null) {
            return;
        }
        ++this.ticksSinceLastSpell;
        if (this.field_70170_p.func_82737_E() % 20L == 0L && !(this.field_70170_p.func_175625_s(this.crystalPos) instanceof SummoningCrytalTile)) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70097_a(DamageSource.func_76365_a((PlayerEntity)FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.field_70170_p))), 99.0f);
            }
            if (this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 2; ++i) {
                    double d0 = this.func_226277_ct_();
                    double d1 = this.func_226278_cu_();
                    double d2 = this.func_226281_cx_();
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197622_o, d0, d1, d2, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    protected PathNavigator func_175447_b(World world) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, world);
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(true);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(6, (Goal)new PerformTaskGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public boolean canPerformAnotherTask() {
        return this.ticksSinceLastSpell > 60 && new EntitySpellResolver(this.spellRecipe, new SpellContext(this.spellRecipe, (LivingEntity)this)).canCast((LivingEntity)this);
    }

    @Nullable
    public BlockPos getTaskLoc() {
        return this.field_70170_p.func_175625_s(this.crystalPos) instanceof SummoningCrytalTile ? ((SummoningCrytalTile)this.field_70170_p.func_175625_s(this.crystalPos)).getNextTaskLoc(this.spellRecipe, this) : null;
    }

    public void castSpell(BlockPos target) {
        if (this.field_70170_p.field_72995_K || !(this.field_70170_p.func_175625_s(this.crystalPos) instanceof SummoningCrytalTile)) {
            return;
        }
        if (((SummoningCrytalTile)this.field_70170_p.func_175625_s(this.crystalPos)).removeManaAround(this.spellRecipe)) {
            EntitySpellResolver resolver = new EntitySpellResolver(this.spellRecipe, new SpellContext(this.spellRecipe, (LivingEntity)this));
            resolver.onCastOnBlock(new BlockRayTraceResult(new Vec3d((double)target.func_177958_n(), (double)target.func_177956_o(), (double)target.func_177952_p()), Direction.UP, target, false), (LivingEntity)this);
        }
        this.ticksSinceLastSpell = 0;
    }

    public boolean enoughManaForTask() {
        if (!(this.field_70170_p.func_175625_s(this.crystalPos) instanceof SummoningCrytalTile) && this.spellRecipe != null && !this.spellRecipe.isEmpty()) {
            return false;
        }
        return ((SummoningCrytalTile)this.field_70170_p.func_175625_s(this.crystalPos)).enoughMana(this.spellRecipe);
    }

    public void func_70645_a(DamageSource source) {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack stack = new ItemStack((IItemProvider)ItemsRegistry.whelpCharm);
            this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack));
        }
        super.func_70645_a(source);
    }

    @Override
    public ItemStack onPickup(ItemStack stack) {
        SummoningCrytalTile tile = this.field_70170_p.func_175625_s(this.crystalPos) instanceof SummoningCrytalTile ? (SummoningCrytalTile)this.field_70170_p.func_175625_s(this.crystalPos) : null;
        return tile == null ? stack : tile.insertItem(stack);
    }

    @Override
    public ItemStack onPlaceBlock() {
        ItemStack heldStack = this.getHeldStack();
        if (heldStack == null) {
            return ItemStack.field_190927_a;
        }
        SummoningCrytalTile tile = this.field_70170_p.func_175625_s(this.crystalPos) instanceof SummoningCrytalTile ? (SummoningCrytalTile)this.field_70170_p.func_175625_s(this.crystalPos) : null;
        return tile == null ? heldStack : tile.getItem(heldStack.func_77973_b());
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<AbstractSpellPart> spellParts = SpellRecipeUtil.getSpellsFromTagString(this.getRecipeString());
        String spellString = spellParts.size() > 4 ? SpellRecipeUtil.getDisplayString(spellParts.subList(0, 4)) + "..." : SpellRecipeUtil.getDisplayString(spellParts);
        String itemString = this.getHeldStack() == ItemStack.field_190927_a ? "Nothing." : this.getHeldStack().func_200301_q().func_150254_d();
        String itemAction = this.getHeldStack().func_77973_b() instanceof BlockItem ? "Placing: " : "Using: ";
        list.add("Casting: " + spellString);
        list.add(itemAction + itemString);
        list.add("Strict mode: " + this.field_70180_af.func_187225_a(STRICT_MODE));
        return list;
    }

    public EntityType<?> func_200600_R() {
        return ModEntities.ENTITY_WHELP_TYPE;
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        if (this.crystalPos != null) {
            tag.func_74768_a("summoner_x", this.crystalPos.func_177958_n());
            tag.func_74768_a("summoner_y", this.crystalPos.func_177956_o());
            tag.func_74768_a("summoner_z", this.crystalPos.func_177952_p());
        }
        tag.func_74768_a("last_spell", this.ticksSinceLastSpell);
        if (this.spellRecipe != null) {
            tag.func_74778_a("spell", SpellRecipeUtil.serializeForNBT(this.spellRecipe));
        }
        if (this.getHeldStack() != null) {
            CompoundNBT itemTag = new CompoundNBT();
            this.getHeldStack().func_77955_b(itemTag);
            tag.func_218657_a("held", (INBT)itemTag);
        }
        tag.func_74757_a("strict", ((Boolean)this.field_70180_af.func_187225_a(STRICT_MODE)).booleanValue());
    }

    public String getRecipeString() {
        return (String)this.field_70180_af.func_187225_a(SPELL_STRING);
    }

    public void setRecipeString(String recipeString) {
        this.field_70180_af.func_187227_b(SPELL_STRING, (Object)recipeString);
    }

    public ItemStack getHeldStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(HELD_ITEM);
    }

    public void setHeldStack(ItemStack stack) {
        this.field_70180_af.func_187227_b(HELD_ITEM, (Object)stack);
    }

    @Override
    public boolean onDispel(@Nullable LivingEntity caster) {
        if (this.field_70128_L) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K) {
            ItemStack stack = new ItemStack((IItemProvider)ItemsRegistry.whelpCharm);
            this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack));
            ParticleUtil.spawnPoof((ServerWorld)this.field_70170_p, this.func_180425_c());
            this.func_70106_y();
        }
        return true;
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("summoner_x")) {
            this.crystalPos = new BlockPos(tag.func_74762_e("summoner_x"), tag.func_74762_e("summoner_y"), tag.func_74762_e("summoner_z"));
        }
        this.spellRecipe = SpellRecipeUtil.getSpellsFromTagString(tag.func_74779_i("spell"));
        this.ticksSinceLastSpell = tag.func_74762_e("last_spell");
        if (tag.func_74764_b("held")) {
            this.setHeldStack(ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)tag.func_74781_a("held"))));
        }
        this.field_70180_af.func_187227_b(STRICT_MODE, (Object)tag.func_74767_n("strict"));
        if (this.spellRecipe != null) {
            this.setRecipeString(SpellRecipeUtil.serializeForNBT(this.spellRecipe));
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a((double)0.4f);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HELD_ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(SPELL_STRING, (Object)"");
        this.field_70180_af.func_187214_a(STRICT_MODE, (Object)true);
    }
}

