/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.common.block.tile.WixieCauldronTile;
import com.hollingsworth.arsnouveau.common.entity.AbstractFlyingCreature;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayerFactory;
import software.bernie.geckolib.animation.builder.AnimationBuilder;
import software.bernie.geckolib.animation.controller.EntityAnimationController;
import software.bernie.geckolib.entity.IAnimatedEntity;
import software.bernie.geckolib.event.AnimationTestEvent;
import software.bernie.geckolib.manager.EntityAnimationManager;

public class EntityWixie
extends AbstractFlyingCreature
implements IAnimatedEntity {
    EntityAnimationManager manager = new EntityAnimationManager();
    EntityAnimationController<EntityWixie> idleController = new EntityAnimationController((Entity)this, "idleController", 20.0f, this::idlePredicate);
    public static final DataParameter<Boolean> TAMED = EntityDataManager.func_187226_a(EntityWixie.class, (IDataSerializer)DataSerializers.field_187198_h);
    BlockPos cauldronPos;

    private <E extends Entity> boolean idlePredicate(AnimationTestEvent<E> event) {
        this.manager.setAnimationSpeed(1.0);
        this.idleController.setAnimation(new AnimationBuilder().addAnimation("idle"));
        return true;
    }

    public EntityAnimationManager getAnimationManager() {
        return this.manager;
    }

    protected EntityWixie(EntityType<? extends AbstractFlyingCreature> type, World worldIn) {
        super(type, worldIn);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 10, true);
        this.setupAnimations();
        this.addGoalsAfterConstructor();
    }

    public EntityWixie(World world, boolean isTamed, BlockPos pos) {
        super(ModEntities.ENTITY_WIXIE_TYPE, world);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.cauldronPos = pos;
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 10, true);
        this.field_70180_af.func_187227_b(TAMED, (Object)isTamed);
        this.setupAnimations();
        this.addGoalsAfterConstructor();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!(this.field_70170_p.field_72995_K || this.cauldronPos != null && this.field_70170_p.func_175625_s(this.cauldronPos) instanceof WixieCauldronTile)) {
            this.func_70097_a(DamageSource.func_76365_a((PlayerEntity)FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.field_70170_p))), 99.0f);
        }
    }

    public List<PrioritizedGoal> getTamedGoals() {
        ArrayList<PrioritizedGoal> list = new ArrayList<PrioritizedGoal>();
        list.add(new PrioritizedGoal(3, (Goal)new LookRandomlyGoal((MobEntity)this)));
        return list;
    }

    public List<PrioritizedGoal> getUntamedGoals() {
        ArrayList<PrioritizedGoal> list = new ArrayList<PrioritizedGoal>();
        list.add(new PrioritizedGoal(3, (Goal)new LookRandomlyGoal((MobEntity)this)));
        return list;
    }

    public void setupAnimations() {
        this.manager.addAnimationController(this.idleController);
    }

    protected void addGoalsAfterConstructor() {
        if (this.field_70170_p.func_201670_d()) {
            return;
        }
        for (PrioritizedGoal goal : this.getGoals()) {
            this.field_70714_bg.func_75776_a(goal.func_220770_h(), goal.func_220772_j());
        }
    }

    public List<PrioritizedGoal> getGoals() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMED) != false ? this.getTamedGoals() : this.getUntamedGoals();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TAMED, (Object)false);
    }

    public boolean func_213397_c(double p_213397_1_) {
        return false;
    }

    protected PathNavigator func_175447_b(World world) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, world);
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(true);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("summoner_x")) {
            this.cauldronPos = new BlockPos(tag.func_74762_e("summoner_x"), tag.func_74762_e("summoner_y"), tag.func_74762_e("summoner_z"));
        }
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        if (this.cauldronPos != null) {
            tag.func_74768_a("summoner_x", this.cauldronPos.func_177958_n());
            tag.func_74768_a("summoner_y", this.cauldronPos.func_177956_o());
            tag.func_74768_a("summoner_z", this.cauldronPos.func_177952_p());
        }
    }
}

