/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.sylph;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.EntitySylph;
import com.hollingsworth.arsnouveau.common.entity.goal.DistanceRestrictedGoal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayerFactory;

public class BonemealGoal
extends DistanceRestrictedGoal {
    private int timeGrowing;
    BlockPos growPos;
    EntitySylph sylph;
    public final Predicate<BlockState> IS_GRASS = BlockStateMatcher.func_177638_a((Block)Blocks.field_196658_i);

    public BonemealGoal(EntitySylph sylph) {
        super(() -> sylph.func_180425_c(), 0);
        this.sylph = sylph;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public BonemealGoal(EntitySylph sylph, Supplier<BlockPos> from, int distanceFrom) {
        super(from, distanceFrom);
        this.sylph = sylph;
    }

    public void func_75251_c() {
        this.timeGrowing = 0;
        this.growPos = null;
    }

    public void func_75246_d() {
        if (this.growPos == null) {
            return;
        }
        if (BlockUtil.distanceFrom(this.sylph.func_180425_c(), this.growPos) > 1.2) {
            this.sylph.func_70661_as().func_75492_a((double)this.growPos.func_177958_n(), (double)this.growPos.func_177956_o(), (double)this.growPos.func_177952_p(), 1.2);
        } else {
            ServerWorld world = (ServerWorld)this.sylph.field_70170_p;
            world.func_195598_a((IParticleData)ParticleTypes.field_218420_D, (double)this.growPos.func_177958_n() + 0.5, (double)this.growPos.func_177956_o() + 1.1, (double)this.growPos.func_177952_p() + 0.5, 1, ParticleUtil.inRange(-0.2, 0.2), 0.0, ParticleUtil.inRange(-0.2, 0.2), 0.01);
            --this.timeGrowing;
            if (this.timeGrowing <= 0) {
                this.sylph.timeSinceBonemeal = 0;
                ItemStack stack = new ItemStack((IItemProvider)Items.field_196106_bc);
                BoneMealItem.applyBonemeal((ItemStack)stack, (World)world, (BlockPos)this.growPos, (PlayerEntity)FakePlayerFactory.getMinecraft((ServerWorld)world));
            }
        }
    }

    public boolean func_75253_b() {
        return this.timeGrowing > 0 && this.growPos != null && this.sylph.timeSinceBonemeal >= 6000 && this.isInRange(this.growPos);
    }

    public boolean func_75250_a() {
        return this.isInRange(this.sylph.func_180425_c()) && this.sylph.timeSinceBonemeal >= 6000 && this.sylph.field_70170_p.field_73012_v.nextInt(5) == 0;
    }

    public void func_75249_e() {
        World world = this.sylph.field_70170_p;
        int range = 4;
        if (this.IS_GRASS.test(world.func_180495_p(this.sylph.func_180425_c().func_177977_b())) && world.func_180495_p(this.sylph.func_180425_c()).func_185904_a() == Material.field_151579_a) {
            this.growPos = this.sylph.func_180425_c().func_177977_b();
        } else {
            ArrayList list = new ArrayList();
            BlockPos.func_218281_b((BlockPos)this.sylph.func_180425_c().func_177982_a(range, range, range), (BlockPos)this.sylph.func_180425_c().func_177982_a(-range, -range, -range)).forEach(bp -> {
                if (this.IS_GRASS.test(world.func_180495_p(bp = bp.func_185334_h())) && world.func_180495_p(bp.func_177984_a()).func_185904_a() == Material.field_151579_a) {
                    list.add(bp);
                }
            });
            Collections.shuffle(list);
            if (!list.isEmpty()) {
                this.growPos = (BlockPos)list.get(0);
            }
        }
        this.timeGrowing = 60;
    }
}

