/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.sylph;

import com.hollingsworth.arsnouveau.api.util.DropDistribution;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.EntitySylph;
import com.hollingsworth.arsnouveau.common.entity.goal.sylph.EvaluateGroveGoal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class GenerateDropsGoal
extends Goal {
    EntitySylph sylph;
    public List<BlockPos> locList;
    int timeGathering;

    public GenerateDropsGoal(EntitySylph sylph) {
        this.sylph = sylph;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public void func_75251_c() {
        this.timeGathering = 100;
        this.locList = null;
    }

    public int getDropsByDiversity() {
        return this.sylph.diversityScore / 2;
    }

    public int getTimerByMood() {
        int mood = (Integer)this.sylph.func_184212_Q().func_187225_a(EntitySylph.MOOD_SCORE);
        if (mood >= 1000) {
            return 20;
        }
        if (mood >= 750) {
            return 40;
        }
        if (mood >= 500) {
            return 60;
        }
        if (mood >= 250) {
            return 80;
        }
        return 100;
    }

    public void func_75246_d() {
        World world = this.sylph.func_130014_f_();
        --this.timeGathering;
        if (this.locList == null || this.timeGathering <= 0) {
            return;
        }
        for (BlockPos growPos : this.locList) {
            ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_218420_D, (double)growPos.func_177958_n() + 0.5, (double)growPos.func_177956_o() + 0.5, (double)growPos.func_177952_p() + 0.5, 1, ParticleUtil.inRange(-0.2, 0.2), 0.0, ParticleUtil.inRange(-0.2, 0.2), 0.01);
        }
        --this.timeGathering;
        if (this.timeGathering == 0 && this.sylph.removeManaForDrops()) {
            this.sylph.timeUntilGather = this.getTimerByMood() * 20;
            DropDistribution<BlockState> blockDropDistribution = new DropDistribution<BlockState>(this.sylph.genTable);
            int numDrops = this.getDropsByDiversity() + 3;
            for (int i = 0; i < numDrops; ++i) {
                BlockState block = blockDropDistribution.nextDrop();
                if (block == null) {
                    return;
                }
                for (ItemStack s : this.getDrops(blockDropDistribution)) {
                    this.sylph.onPickup(s);
                }
            }
        }
    }

    public List<ItemStack> getDrops(DropDistribution<BlockState> blockDropDistribution) {
        World world = this.sylph.func_130014_f_();
        Supplier<List> getDrops = () -> Block.func_220070_a((BlockState)((BlockState)blockDropDistribution.nextDrop()), (ServerWorld)((ServerWorld)world), (BlockPos)this.sylph.func_180425_c(), null);
        List drops = getDrops.get();
        for (int numRerolls = 0; numRerolls < 4 && (drops.isEmpty() || ((ItemStack)drops.get(0)).func_77973_b() == Blocks.field_150346_d.func_199767_j()); ++numRerolls) {
            drops = getDrops.get();
        }
        return drops;
    }

    public boolean func_75253_b() {
        return this.sylph.timeUntilGather <= 0 && this.timeGathering >= 0 && this.locList != null && this.sylph.crystalPos != null;
    }

    public boolean func_75250_a() {
        return this.sylph.crystalPos != null && this.sylph.genTable != null && this.sylph.timeUntilGather <= 0 && (this.sylph.drops == null || this.sylph.drops.isEmpty()) && this.sylph.enoughManaForTask();
    }

    public void func_75249_e() {
        World world = this.sylph.func_130014_f_();
        if (this.locList == null) {
            this.locList = new ArrayList<BlockPos>();
            for (BlockPos b : BlockPos.func_218278_a((BlockPos)this.sylph.func_180425_c().func_177964_d(4).func_177985_f(4).func_177979_c(3), (BlockPos)this.sylph.func_180425_c().func_177970_e(4).func_177965_g(4).func_177981_b(3))) {
                BlockState state;
                int points;
                if (b.func_177956_o() >= 256 || (points = EvaluateGroveGoal.getScore(state = world.func_180495_p(b))) == 0) continue;
                this.locList.add(b.func_185334_h());
            }
            Collections.shuffle(this.locList);
            if (this.locList.size() > 6) {
                this.locList = this.locList.subList(0, 6);
            }
        }
    }
}

