/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.event;

import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.api.util.MathUtil;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.common.capability.ManaCapability;
import com.hollingsworth.arsnouveau.common.enchantment.EnchantmentRegistry;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketReactiveSpell;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateMana;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="ars_nouveau")
public class EventHandler {
    @SubscribeEvent
    public static void playerRespawn(PlayerEvent.PlayerRespawnEvent e) {
        EventHandler.syncPlayerEvent(e.getPlayer());
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone e) {
        if (e.getOriginal().field_70170_p.field_72995_K) {
            return;
        }
        ManaCapability.getMana((LivingEntity)e.getEntity()).ifPresent(newMana -> ManaCapability.getMana((LivingEntity)e.getOriginal()).ifPresent(origMana -> {
            newMana.setMaxMana(origMana.getMaxMana());
            newMana.setGlyphBonus(origMana.getGlyphBonus());
            newMana.setBookTier(origMana.getBookTier());
            Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)e.getEntity()), (Object)new PacketUpdateMana(newMana.getCurrentMana(), newMana.getMaxMana(), newMana.getGlyphBonus(), newMana.getBookTier()));
        }));
    }

    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.StartTracking e) {
        EventHandler.syncPlayerEvent(e.getPlayer());
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent e) {
        EventHandler.syncPlayerEvent(e.getPlayer());
    }

    @SubscribeEvent
    public static void livingHitEvent(LivingHurtEvent e) {
        LivingEntity entity = e.getEntityLiving();
        if (entity.func_130014_f_().field_72995_K || !(entity instanceof PlayerEntity)) {
            return;
        }
        for (ItemStack s : entity.func_184193_aE()) {
            EventHandler.castSpell((PlayerEntity)entity, s);
        }
    }

    public static void castSpell(PlayerEntity playerIn, ItemStack s) {
        if ((double)EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.REACTIVE_ENCHANTMENT, (ItemStack)s) * 0.25 >= Math.random() && s.func_77942_o() && s.func_77978_p().func_74764_b("spell")) {
            ArrayList<AbstractSpellPart> list = SpellParchment.getSpellRecipe(s);
            SpellResolver resolver = new SpellResolver(list, true, new SpellContext(list, (LivingEntity)playerIn));
            RayTraceResult result = playerIn.func_213324_a(5.0, 0.0f, false);
            EntityRayTraceResult entityRes = MathUtil.getLookedAtEntity((LivingEntity)playerIn, 25);
            ItemStack stack = playerIn.func_184614_ca();
            Hand handIn = Hand.MAIN_HAND;
            if (entityRes != null && entityRes.func_216348_a() instanceof LivingEntity) {
                resolver.onCastOnEntity(stack, (LivingEntity)playerIn, (LivingEntity)entityRes.func_216348_a(), handIn);
                return;
            }
            if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                ItemUseContext context = new ItemUseContext(playerIn, handIn, (BlockRayTraceResult)result);
                resolver.onCastOnBlock(context);
                return;
            }
            resolver.onCast(stack, (LivingEntity)playerIn, playerIn.func_130014_f_());
        }
    }

    @SubscribeEvent
    public static void leftClickBlock(PlayerInteractEvent.LeftClickBlock e) {
        LivingEntity entity = e.getEntityLiving();
        if (entity.func_130014_f_().field_72995_K || !(entity instanceof PlayerEntity)) {
            return;
        }
        ItemStack s = e.getItemStack();
        EventHandler.castSpell((PlayerEntity)entity, s);
    }

    @SubscribeEvent
    public static void playerAttackEntity(AttackEntityEvent e) {
        LivingEntity entity = e.getEntityLiving();
        if (entity == null || entity.func_130014_f_().field_72995_K || !(entity instanceof PlayerEntity)) {
            return;
        }
        ItemStack s = e.getEntityLiving().func_184614_ca();
        EventHandler.castSpell((PlayerEntity)entity, s);
    }

    @SubscribeEvent
    public static void leftClickAir(PlayerInteractEvent.LeftClickEmpty e) {
        LivingEntity entity = e.getEntityLiving();
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.REACTIVE_ENCHANTMENT, (ItemStack)e.getItemStack()) > 0) {
            Networking.INSTANCE.sendToServer((Object)new PacketReactiveSpell());
        }
    }

    @SubscribeEvent
    public static void jumpEvent(LivingEvent.LivingJumpEvent e) {
        if (e.getEntityLiving() == null || e.getEntityLiving().func_70660_b(Effects.field_76421_d) == null) {
            return;
        }
        EffectInstance effectInstance = e.getEntityLiving().func_70660_b(Effects.field_76421_d);
        if (effectInstance.func_76458_c() >= 20) {
            e.getEntityLiving().func_213293_j(0.0, 0.0, 0.0);
        }
    }

    public static void syncPlayerEvent(PlayerEntity playerEntity) {
        if (playerEntity instanceof ServerPlayerEntity) {
            ManaCapability.getMana((LivingEntity)playerEntity).ifPresent(mana -> {
                mana.setMaxMana(ManaUtil.getMaxMana(playerEntity));
                mana.setGlyphBonus(mana.getGlyphBonus());
                Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)playerEntity), (Object)new PacketUpdateMana(mana.getCurrentMana(), mana.getMaxMana(), mana.getGlyphBonus(), mana.getBookTier()));
            });
        }
    }

    @SubscribeEvent
    public static void playerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        String book_tag;
        if (e.getEntityLiving().func_130014_f_().field_72995_K) {
            return;
        }
        CompoundNBT tag = e.getPlayer().getPersistentData().func_74775_l("PlayerPersisted");
        if (tag.func_74767_n(book_tag = "an_book_")) {
            return;
        }
        LivingEntity entity = e.getEntityLiving();
        e.getEntityLiving().func_130014_f_().func_217376_c((Entity)new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), new ItemStack((IItemProvider)ItemsRegistry.wornNotebook)));
        tag.func_74757_a(book_tag, true);
        e.getPlayer().getPersistentData().func_218657_a("PlayerPersisted", (INBT)tag);
    }

    @SubscribeEvent
    public static void playerOnTick(TickEvent.PlayerTickEvent e) {
        if (e.player instanceof ServerPlayerEntity && e.player.field_70170_p.func_82737_E() % 5L == 0L) {
            if (e.player.field_70170_p.func_82737_E() % 20L == 0L) {
                ManaCapability.getMana((LivingEntity)e.player).ifPresent(mana -> {
                    double regenPerSecond = ManaUtil.getManaRegen(e.player);
                    if (mana.getCurrentMana() != mana.getMaxMana()) {
                        mana.addMana((int)regenPerSecond);
                        Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)e.player), (Object)new PacketUpdateMana(mana.getCurrentMana(), mana.getMaxMana(), mana.getGlyphBonus(), mana.getBookTier()));
                    }
                });
            }
            if (e.player.field_70170_p.func_82737_E() % 10L == 0L) {
                ManaCapability.getMana((LivingEntity)e.player).ifPresent(mana -> {
                    mana.setMaxMana(ManaUtil.getMaxMana(e.player));
                    Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)e.player), (Object)new PacketUpdateMana(mana.getCurrentMana(), mana.getMaxMana(), mana.getGlyphBonus(), mana.getBookTier()));
                });
            }
        }
    }

    @SubscribeEvent
    public static void worldTick(TickEvent.WorldTickEvent e) {
        World world = e.world;
        if (world.field_72995_K) {
            return;
        }
        EventQueue.getInstance().tick();
    }

    @SubscribeEvent
    public static void clientTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++ClientInfo.ticksInGame;
        }
    }

    @SubscribeEvent
    public static void playerDamaged(LivingDamageEvent e) {
        if (e.getEntityLiving() != null && e.getEntityLiving().func_193076_bZ().containsKey((Object)ModPotions.SHIELD_POTION) && (e.getSource() == DamageSource.field_76376_m || e.getSource() == DamageSource.field_76377_j)) {
            float damage = e.getAmount() - 1.0f * (float)((EffectInstance)e.getEntityLiving().func_193076_bZ().get((Object)ModPotions.SHIELD_POTION)).func_76458_c();
            if (damage < 0.0f) {
                damage = 0.0f;
            }
            e.setAmount(damage);
        }
    }

    @SubscribeEvent
    public static void worldUnload(WorldEvent.Unload e) {
        EventQueue.getInstance().clear();
    }
}

