/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.PortUtil;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class DominionWand
extends ModItem {
    public DominionWand() {
        super("dominion_wand");
    }

    public void func_77663_a(ItemStack stack, World p_77663_2_, Entity p_77663_3_, int p_77663_4_, boolean p_77663_5_) {
        super.func_77663_a(stack, p_77663_2_, p_77663_3_, p_77663_4_, p_77663_5_);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
        return false;
    }

    public boolean func_111207_a(ItemStack doNotUseStack, PlayerEntity playerEntity, LivingEntity target, Hand hand) {
        System.out.println("wanded");
        if (playerEntity.field_70170_p.field_72995_K || hand != Hand.MAIN_HAND) {
            return true;
        }
        ItemStack stack = playerEntity.func_184586_b(hand);
        if (playerEntity.func_225608_bj_() && target instanceof IWandable) {
            System.out.println("wanding");
            ((IWandable)target).onWanded(playerEntity);
            this.clear(stack, playerEntity);
            return true;
        }
        if ((this.getPos(stack) == null || this.getPos(stack).equals((Object)new BlockPos(0, 0, 0))) && this.getEntityID(stack) == -1) {
            this.setEntityID(stack, target.func_145782_y());
            PortUtil.sendMessage(playerEntity, "Stored entity");
            return true;
        }
        World world = playerEntity.func_130014_f_();
        if (this.getPos(stack) != null && world.func_175625_s(this.getPos(stack)) instanceof IWandable) {
            ((IWandable)world.func_175625_s(this.getPos(stack))).onFinishedConnectionFirst(this.getPos(stack), target, playerEntity);
        }
        if (target instanceof IWandable) {
            ((IWandable)target).onFinishedConnectionLast(this.getPos(stack), target, playerEntity);
            this.clear(stack, playerEntity);
        }
        return true;
    }

    public void clear(ItemStack stack, PlayerEntity playerEntity) {
        this.setPosTag(stack, null, 0);
        this.setEntityID(stack, -1);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195991_k().field_72995_K || context.func_195999_j() == null) {
            return super.func_195939_a(context);
        }
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        PlayerEntity playerEntity = context.func_195999_j();
        ItemStack stack = context.func_195996_i();
        if (playerEntity.func_225608_bj_() && world.func_175625_s(pos) instanceof IWandable) {
            ((IWandable)world.func_175625_s(pos)).onWanded(playerEntity);
            this.clear(stack, playerEntity);
            return ActionResultType.CONSUME;
        }
        if (this.getEntityID(stack) == -1 && (this.getPos(stack) == null || this.getPos(stack).equals((Object)new BlockPos(0, 0, 0)))) {
            this.setPosTag(stack, pos, playerEntity.field_71093_bK.func_186068_a());
            PortUtil.sendMessage(playerEntity, "Position set.");
            return ActionResultType.SUCCESS;
        }
        if (this.getPos(stack) != null && world.func_175625_s(this.getPos(stack)) instanceof IWandable) {
            ((IWandable)world.func_175625_s(this.getPos(stack))).onFinishedConnectionFirst(pos, (LivingEntity)world.func_73045_a(this.getEntityID(stack)), playerEntity);
        }
        if (world.func_175625_s(pos) instanceof IWandable) {
            ((IWandable)world.func_175625_s(pos)).onFinishedConnectionLast(this.getPos(stack), (LivingEntity)world.func_73045_a(this.getEntityID(stack)), playerEntity);
        }
        if (this.getEntityID(stack) != -1 && world.func_73045_a(this.getEntityID(stack)) instanceof IWandable) {
            ((IWandable)world.func_73045_a(this.getEntityID(stack))).onFinishedConnectionFirst(pos, null, playerEntity);
        }
        this.clear(stack, playerEntity);
        return super.func_195939_a(context);
    }

    public void drawConnection(BlockPos pos1, BlockPos pos2, ServerWorld world) {
        ParticleUtil.beam(pos1, pos2, (World)world);
    }

    public void setPosTag(ItemStack stack, BlockPos pos, int dim) {
        CompoundNBT tag = stack.func_77978_p();
        if (pos == null && tag != null && tag.func_74764_b("to_x")) {
            tag.func_82580_o("to_x");
            tag.func_82580_o("to_y");
            tag.func_82580_o("to_z");
            tag.func_82580_o("to_dim");
        } else if (pos != null && tag != null) {
            stack.func_77978_p().func_74768_a("to_x", pos.func_177958_n());
            stack.func_77978_p().func_74768_a("to_y", pos.func_177956_o());
            stack.func_77978_p().func_74768_a("to_z", pos.func_177952_p());
            stack.func_77978_p().func_74768_a("to_dim", dim);
        }
    }

    public void setEntityID(ItemStack stack, int id) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return;
        }
        stack.func_77978_p().func_74768_a("en_id", id);
    }

    public int getEntityID(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return -1;
        }
        return stack.func_77978_p().func_74762_e("en_id");
    }

    public BlockPos getPos(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        CompoundNBT tag = stack.func_77978_p();
        return new BlockPos(tag.func_74762_e("to_x"), tag.func_74762_e("to_y"), tag.func_74762_e("to_z"));
    }

    public int getDimension(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return -999;
        }
        return stack.func_77978_p().func_74762_e("dim");
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag p_77624_4_) {
        BlockPos pos = this.getPos(stack);
        tooltip.add((ITextComponent)new StringTextComponent(this.getEntityID(stack) == -1 ? "No entity set" : "Entity stored."));
        if (pos == null) {
            tooltip.add((ITextComponent)new StringTextComponent("No location set."));
            return;
        }
        tooltip.add((ITextComponent)new StringTextComponent("Stored: " + DominionWand.getPosString(pos)));
    }

    public static String getPosString(BlockPos pos) {
        return "X: " + pos.func_177958_n() + " Y: " + pos.func_177956_o() + " Z:" + pos.func_177952_p();
    }
}

