/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.item.IScribeable;
import com.hollingsworth.arsnouveau.common.PortUtil;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemScroll
extends ModItem
implements IScribeable {
    public static String ITEM_PREFIX = "item_";

    public ItemScroll(String reg) {
        super(reg);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
    }

    public List<ItemStack> getItems(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (tag == null) {
            return stacks;
        }
        for (String s : tag.func_150296_c()) {
            if (!s.contains(ITEM_PREFIX)) continue;
            stacks.add(ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l(s)));
        }
        return stacks;
    }

    public boolean addItem(ItemStack itemToAdd, CompoundNBT tag) {
        CompoundNBT itemTag = new CompoundNBT();
        itemToAdd.func_77955_b(itemTag);
        tag.func_218657_a(this.getItemKey(itemToAdd), (INBT)itemTag);
        return true;
    }

    public boolean removeItem(ItemStack itemToRemove, CompoundNBT tag) {
        tag.func_82580_o(this.getItemKey(itemToRemove));
        return true;
    }

    public boolean containsItem(ItemStack stack, CompoundNBT tag) {
        return tag.func_74764_b(this.getItemKey(stack));
    }

    public String getItemKey(ItemStack stack) {
        return ITEM_PREFIX + stack.func_77973_b().getRegistryName().toString();
    }

    @Override
    public boolean onScribe(World world, BlockPos pos, PlayerEntity player, Hand handIn, ItemStack thisStack) {
        ItemScroll itemScroll = (ItemScroll)thisStack.func_77973_b();
        ItemStack stackToWrite = player.func_184586_b(handIn);
        CompoundNBT tag = thisStack.func_77978_p();
        if (stackToWrite == ItemStack.field_190927_a || tag == null) {
            return false;
        }
        if (itemScroll.containsItem(stackToWrite, tag)) {
            PortUtil.sendMessage(player, (ITextComponent)new TranslationTextComponent("ars_nouveau.scribe.item_removed", new Object[0]));
            return this.removeItem(stackToWrite, tag);
        }
        PortUtil.sendMessage(player, (ITextComponent)new TranslationTextComponent("ars_nouveau.scribe.item_added", new Object[0]));
        return itemScroll.addItem(stackToWrite, tag);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip2, ITooltipFlag flagIn) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (String string : tag.func_150296_c()) {
            if (!string.contains(ITEM_PREFIX)) continue;
            stacks.add(ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l(string)));
        }
        for (ItemStack itemStack : stacks) {
            tooltip2.add(itemStack.func_200301_q());
        }
    }
}

