/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.item.IScribeable;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.util.MathUtil;
import com.hollingsworth.arsnouveau.api.util.SpellRecipeUtil;
import com.hollingsworth.arsnouveau.client.keybindings.ModKeyBindings;
import com.hollingsworth.arsnouveau.client.renderer.items.SpellBookRenderer;
import com.hollingsworth.arsnouveau.common.capability.ManaCapability;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketOpenGUI;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class SpellBook
extends Item
implements ISpellTier,
IScribeable {
    public static final String BOOK_MODE_TAG = "mode";
    public static final String UNLOCKED_SPELLS = "spells";
    public static final int SEGMENTS = 10;
    public ISpellTier.Tier tier;

    public SpellBook(ISpellTier.Tier tier) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ArsNouveau.itemGroup).setISTER(() -> SpellBookRenderer::new));
        this.tier = tier;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        if (!worldIn.field_72995_K && worldIn.func_82737_E() % 5L == 0L && !stack.func_77942_o()) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a(BOOK_MODE_TAG, 0);
            StringBuilder starting_spells = new StringBuilder();
            if (stack.func_77973_b() == ItemsRegistry.creativeSpellBook) {
                ArsNouveauAPI.getInstance().getSpell_map().values().forEach(s -> starting_spells.append(",").append(s.getTag().trim()));
            } else {
                ArsNouveauAPI.getInstance().getStartingSpells().forEach(s -> starting_spells.append(",").append(s.getTag().trim()));
            }
            tag.func_74778_a(UNLOCKED_SPELLS, starting_spells.toString());
            stack.func_77982_d(tag);
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!stack.func_77942_o()) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        ManaCapability.getMana((LivingEntity)playerIn).ifPresent(iMana -> {
            if (iMana.getBookTier() < this.tier.ordinal()) {
                iMana.setBookTier(this.tier.ordinal());
            }
            if (iMana.getGlyphBonus() < SpellBook.getUnlockedSpells(stack.func_77978_p()).size()) {
                iMana.setGlyphBonus(SpellBook.getUnlockedSpells(stack.func_77978_p()).size());
            }
        });
        RayTraceResult result = playerIn.func_213324_a(5.0, 0.0f, false);
        if (result instanceof BlockRayTraceResult && worldIn.func_175625_s(((BlockRayTraceResult)result).func_216350_a()) != null) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (worldIn.field_72995_K || !stack.func_77942_o()) {
            return new ActionResult(ActionResultType.FAIL, (Object)stack);
        }
        if (SpellBook.getMode(stack.func_77978_p()) == 0 && playerIn instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)playerIn;
            Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketOpenGUI(stack.func_77978_p(), this.getTier().ordinal(), SpellBook.getUnlockedSpellString(player.func_184586_b(handIn).func_77978_p())));
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        SpellResolver resolver = new SpellResolver(this.getCurrentRecipe(stack), new SpellContext(this.getCurrentRecipe(stack), (LivingEntity)playerIn));
        EntityRayTraceResult entityRes = MathUtil.getLookedAtEntity((LivingEntity)playerIn, 25);
        if (entityRes != null && entityRes.func_216348_a() instanceof LivingEntity) {
            resolver.onCastOnEntity(stack, (LivingEntity)playerIn, (LivingEntity)entityRes.func_216348_a(), handIn);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            ItemUseContext context = new ItemUseContext(playerIn, handIn, (BlockRayTraceResult)result);
            resolver.onCastOnBlock(context);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        resolver.onCast(stack, (LivingEntity)playerIn, worldIn);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @Override
    public boolean onScribe(World world, BlockPos pos, PlayerEntity player, Hand handIn, ItemStack stack) {
        if (!(player.func_184586_b(handIn).func_77973_b() instanceof SpellBook)) {
            return false;
        }
        ArrayList<AbstractSpellPart> spellParts = SpellBook.getUnlockedSpells(player.func_184586_b(handIn).func_77978_p());
        int unlocked = 0;
        for (AbstractSpellPart spellPart : spellParts) {
            if (!SpellBook.unlockSpell(stack.func_77978_p(), spellPart)) continue;
            ++unlocked;
        }
        player.func_145747_a((ITextComponent)new StringTextComponent("Copied " + unlocked + " new spells to the book."));
        return true;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        return ActionResultType.CONSUME;
    }

    public ArrayList<AbstractSpellPart> getCurrentRecipe(ItemStack stack) {
        return SpellBook.getRecipeFromTag(stack.func_77978_p(), SpellBook.getMode(stack.func_77978_p()));
    }

    public static ArrayList<AbstractSpellPart> getRecipeFromTag(CompoundNBT tag, int r_slot) {
        String[] recipeList;
        ArrayList<AbstractSpellPart> recipe = new ArrayList<AbstractSpellPart>();
        String recipeStr = SpellBook.getRecipeString(tag, r_slot);
        if (recipeStr.length() <= 3) {
            return recipe;
        }
        for (String id : recipeList = recipeStr.substring(1, recipeStr.length() - 1).split(",")) {
            if (!ArsNouveauAPI.getInstance().getSpell_map().containsKey(id.trim())) continue;
            recipe.add(ArsNouveauAPI.getInstance().getSpell_map().get(id.trim()));
        }
        return recipe;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
        return true;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return false;
    }

    public static void setSpellName(CompoundNBT tag, String name, int slot) {
        tag.func_74778_a(slot + "_name", name);
    }

    public static String getSpellName(CompoundNBT tag, int slot) {
        if (slot == 0) {
            return "Create Mode";
        }
        return tag.func_74779_i(slot + "_name");
    }

    public static String getSpellName(CompoundNBT tag) {
        return SpellBook.getSpellName(tag, SpellBook.getMode(tag));
    }

    public static String getRecipeString(CompoundNBT tag, int spell_slot) {
        return tag.func_74779_i(spell_slot + "recipe");
    }

    public static void setRecipe(CompoundNBT tag, String recipe, int spell_slot) {
        tag.func_74778_a(spell_slot + "recipe", recipe);
    }

    public static int getMode(CompoundNBT tag) {
        return tag.func_74762_e(BOOK_MODE_TAG);
    }

    public static void setMode(CompoundNBT tag, int mode) {
        tag.func_74768_a(BOOK_MODE_TAG, mode);
    }

    public static ArrayList<AbstractSpellPart> getUnlockedSpells(CompoundNBT tag) {
        return SpellRecipeUtil.getSpellsFromString(tag.func_74779_i(UNLOCKED_SPELLS));
    }

    public static String getUnlockedSpellString(CompoundNBT tag) {
        return tag.func_74779_i(UNLOCKED_SPELLS);
    }

    public static boolean unlockSpell(CompoundNBT tag, AbstractSpellPart spellPart) {
        if (SpellBook.containsSpell(tag, spellPart)) {
            return false;
        }
        String newSpells = tag.func_74779_i(UNLOCKED_SPELLS) + "," + spellPart.getTag();
        tag.func_74778_a(UNLOCKED_SPELLS, newSpells);
        return true;
    }

    public static void unlockSpell(CompoundNBT tag, String spellTag) {
        String newSpells = tag.func_74779_i(UNLOCKED_SPELLS) + "," + spellTag;
        tag.func_74778_a(UNLOCKED_SPELLS, newSpells);
    }

    public static boolean containsSpell(CompoundNBT tag, AbstractSpellPart spellPart) {
        return SpellBook.getUnlockedSpells(tag).contains(spellPart);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (stack != null && stack.func_77942_o()) {
            tooltip.add((ITextComponent)new StringTextComponent(SpellBook.getSpellName(stack.func_77978_p())));
            tooltip.add((ITextComponent)new StringTextComponent("Press " + ModKeyBindings.OPEN_SPELL_SELECTION.getKeyBinding().func_197978_k() + " to quick select"));
            tooltip.add((ITextComponent)new StringTextComponent("Press " + ModKeyBindings.OPEN_BOOK.getKeyBinding().func_197978_k() + " to quick craft"));
        }
    }

    @Override
    public ISpellTier.Tier getTier() {
        return this.tier;
    }
}

