/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class WarpScroll
extends ModItem {
    public WarpScroll() {
        super(ItemsRegistry.defaultItemProperties(), "warp_scroll");
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!entity.func_130014_f_().field_72995_K && entity.func_130014_f_().func_180495_p(entity.func_180425_c().func_177977_b()).func_177230_c() == BlockRegistry.ARCANE_BRICKS && this.getPos(stack) != null && this.getDimension(stack) == entity.func_130014_f_().func_201675_m().func_186058_p().func_186068_a() && ManaUtil.hasManaNearby(entity.func_180425_c(), entity.func_130014_f_(), 10, 9000) && BlockRegistry.PORTAL_BLOCK.trySpawnPortal((IWorld)entity.func_130014_f_(), entity.func_180425_c(), this.getPos(stack), this.getDimension(stack)) && ManaUtil.takeManaNearby(entity.func_180425_c(), entity.func_130014_f_(), 10, 9000) != null) {
            BlockPos pos = entity.func_180425_c();
            ServerWorld world = (ServerWorld)entity.func_130014_f_();
            world.func_195598_a((IParticleData)ParticleTypes.field_197599_J, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), 10, (world.field_73012_v.nextDouble() - 0.5) * 2.0, -world.field_73012_v.nextDouble(), (world.field_73012_v.nextDouble() - 0.5) * 2.0, (double)0.1f);
            world.func_184133_a(null, pos, SoundEvents.field_193784_dd, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            stack.func_190918_g(1);
            return true;
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        BlockPos pos = this.getPos(stack);
        if (world.func_201670_d()) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (pos != null) {
            if (this.getDimension(stack) != player.field_71093_bK.func_186068_a()) {
                player.func_145747_a((ITextComponent)new StringTextComponent("Using this scroll from a different dimension would be a bad idea."));
                return ActionResult.func_226251_d_((Object)stack);
            }
            player.func_223102_j((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            stack.func_190918_g(1);
            return ActionResult.func_226250_c_((Object)stack);
        }
        if (player.func_225608_bj_()) {
            ItemStack newWarpStack = new ItemStack((IItemProvider)ItemsRegistry.warpScroll);
            newWarpStack.func_77982_d(new CompoundNBT());
            this.setTeleportTag(newWarpStack, player.func_180425_c(), player.field_71093_bK.func_186068_a());
            if (!player.func_191521_c(newWarpStack)) {
                player.func_145747_a((ITextComponent)new StringTextComponent("There is no room in your inventory."));
                return ActionResult.func_226251_d_((Object)stack);
            }
            player.func_145747_a((ITextComponent)new StringTextComponent("You record your location to your Warp Scroll."));
            stack.func_190918_g(1);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public void setTeleportTag(ItemStack stack, BlockPos pos, int dimension) {
        stack.func_77978_p().func_74768_a("x", pos.func_177958_n());
        stack.func_77978_p().func_74768_a("y", pos.func_177956_o());
        stack.func_77978_p().func_74768_a("z", pos.func_177952_p());
        stack.func_77978_p().func_74768_a("dim", dimension);
    }

    public BlockPos getPos(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        CompoundNBT tag = stack.func_77978_p();
        return new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
    }

    public int getDimension(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return -999;
        }
        return stack.func_77978_p().func_74762_e("dim");
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag p_77624_4_) {
        BlockPos pos = this.getPos(stack);
        if (pos == null) {
            tooltip.add((ITextComponent)new StringTextComponent("No location set."));
            return;
        }
        tooltip.add((ITextComponent)new StringTextComponent("X: " + pos.func_177958_n() + " Y: " + pos.func_177956_o() + " Z:" + pos.func_177952_p()));
    }
}

