/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketBeam {
    private final Vec3d toPos;
    private final Vec3d fromPos;
    private final int duration;

    public PacketBeam(Vec3d from, Vec3d to, int duration) {
        this.fromPos = from;
        this.toPos = to;
        this.duration = duration;
    }

    public static PacketBeam decode(PacketBuffer buf) {
        return new PacketBeam(new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble()), new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble()), buf.readInt());
    }

    public static void encode(PacketBeam msg, PacketBuffer buf) {
        buf.writeDouble(msg.fromPos.field_72450_a);
        buf.writeDouble(msg.fromPos.field_72448_b);
        buf.writeDouble(msg.fromPos.field_72449_c);
        buf.writeDouble(msg.toPos.field_72450_a);
        buf.writeDouble(msg.toPos.field_72448_b);
        buf.writeDouble(msg.toPos.field_72449_c);
        buf.writeInt(msg.duration);
    }

    public static class Handler {
        public static void handle(final PacketBeam message, Supplier<NetworkEvent.Context> ctx) {
            if (ctx.get().getDirection().getReceptionSide().isServer()) {
                ctx.get().setPacketHandled(true);
                return;
            }
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    ArsNouveau.proxy.getMinecraft().field_71441_e.func_217376_c((Entity)new EntityFollowProjectile((World)ArsNouveau.proxy.getMinecraft().field_71441_e, message.fromPos, message.toPos));
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

