/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import software.bernie.geckolib.animation.builder.AnimationBuilder;
import software.bernie.geckolib.animation.controller.AnimationController;
import software.bernie.geckolib.entity.IAnimatedEntity;

public class PacketEntityAnimationSync {
    private final int entityID;
    private final String animationController;
    private final String animation;

    public PacketEntityAnimationSync(Entity entity, String animationController, String animation) {
        this.entityID = entity.func_145782_y();
        this.animationController = animationController;
        this.animation = animation;
    }

    public PacketEntityAnimationSync(int id, String animationController, String animation) {
        this.entityID = id;
        this.animationController = animationController;
        this.animation = animation;
    }

    public static PacketEntityAnimationSync decode(PacketBuffer buf) {
        return new PacketEntityAnimationSync(buf.readInt(), buf.func_218666_n(), buf.func_218666_n());
    }

    public static void encode(PacketEntityAnimationSync msg, PacketBuffer buf) {
        buf.writeInt(msg.entityID);
        buf.func_180714_a(msg.animationController);
        buf.func_180714_a(msg.animation);
    }

    public static class Handler {
        public static void handle(final PacketEntityAnimationSync message, Supplier<NetworkEvent.Context> ctx) {
            if (ctx.get().getDirection().getReceptionSide().isServer()) {
                ctx.get().setPacketHandled(true);
                return;
            }
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    Minecraft mc = Minecraft.func_71410_x();
                    ClientWorld world = mc.field_71441_e;
                    if (world.func_73045_a(message.entityID) instanceof IAnimatedEntity) {
                        System.out.println("Adding animation for " + message.entityID);
                        ((IAnimatedEntity)world.func_73045_a(message.entityID)).getAnimationManager().setAnimationSpeed(2.0);
                        ((AnimationController)((IAnimatedEntity)world.func_73045_a(message.entityID)).getAnimationManager().get((Object)message.animationController)).setAnimation(new AnimationBuilder().addAnimation(message.animation));
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

