/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.common.network.Networking;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketWarpPosition {
    private final int entityID;
    double x;
    double y;
    double z;
    boolean updateAgain;

    public PacketWarpPosition(Entity entity, double x, double y, double z, boolean updateAgain) {
        this.entityID = entity.func_145782_y();
        this.x = x;
        this.y = y;
        this.z = z;
        this.updateAgain = updateAgain;
    }

    public PacketWarpPosition(int id, double x, double y, double z, boolean updateAgain) {
        this.entityID = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.updateAgain = updateAgain;
    }

    public static PacketWarpPosition decode(PacketBuffer buf) {
        return new PacketWarpPosition(buf.readInt(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readBoolean());
    }

    public static void encode(PacketWarpPosition msg, PacketBuffer buf) {
        buf.writeInt(msg.entityID);
        buf.writeDouble(msg.x);
        buf.writeDouble(msg.y);
        buf.writeDouble(msg.z);
        buf.writeBoolean(msg.updateAgain);
    }

    public static class Handler {
        public static void handle(final PacketWarpPosition message, Supplier<NetworkEvent.Context> ctx) {
            if (ctx.get().getDirection().getReceptionSide().isServer()) {
                ctx.get().setPacketHandled(true);
                return;
            }
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    Minecraft mc = Minecraft.func_71410_x();
                    ClientWorld world = mc.field_71441_e;
                    Entity e = world.func_73045_a(message.entityID);
                    if (e == null) {
                        return;
                    }
                    e.func_70107_b(message.x, message.y, message.z);
                    Networking.sendToNearby((World)world, e, (Object)new PacketWarpPosition(e.func_145782_y(), e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), false));
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

