/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EffectBlink
extends AbstractEffect {
    public EffectBlink() {
        super("blink", "Blink");
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        Vec3d vec;
        if (shooter == null) {
            return;
        }
        if (rayTraceResult instanceof EntityRayTraceResult && ((EntityRayTraceResult)rayTraceResult).func_216348_a().equals((Object)shooter)) {
            double distance = 8.0f + 3.0f * (float)this.getAmplificationBonus(augments);
            Vec3d lookVec = new Vec3d(shooter.func_70040_Z().func_82615_a(), 0.0, shooter.func_70040_Z().func_82616_c());
            Vec3d vec2 = shooter.func_213303_ch().func_178787_e(lookVec.func_186678_a(distance));
            BlockPos pos = new BlockPos(vec2);
            if (!EffectBlink.isValidTeleport(world, pos)) {
                for (double i = distance; i >= 0.0; i -= 1.0) {
                    vec2 = shooter.func_213303_ch().func_178787_e(lookVec.func_186678_a(i));
                    pos = new BlockPos(vec2);
                    if (i <= 0.0) {
                        return;
                    }
                    if (EffectBlink.isValidTeleport(world, pos)) break;
                }
            }
            shooter.func_70634_a(vec2.func_82615_a(), vec2.func_82617_b(), vec2.func_82616_c());
        } else if (rayTraceResult instanceof EntityRayTraceResult) {
            Vec3d vec3 = this.safelyGetHitPos(rayTraceResult);
            shooter.func_70634_a(vec3.func_82615_a(), vec3.func_82617_b(), vec3.func_82616_c());
        } else if (rayTraceResult instanceof BlockRayTraceResult && EffectBlink.isValidTeleport(world, new BlockPos(vec = rayTraceResult.func_216347_e()))) {
            shooter.func_70634_a(vec.func_82615_a(), vec.func_82617_b(), vec.func_82616_c());
        }
    }

    @Override
    public boolean dampenIsAllowed() {
        return true;
    }

    public static boolean isValidTeleport(World world, BlockPos pos) {
        return !world.func_180495_p(pos).func_200132_m() && !world.func_180495_p(pos.func_177984_a()).func_200132_m() && !world.func_180495_p(pos.func_177981_b(2)).func_200132_m();
    }

    @Override
    public int getManaCost() {
        return 50;
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.THREE;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_151079_bi;
    }

    @Override
    protected String getBookDescription() {
        return "If the spell hits a block, the caster will be teleported to that location. If using Self, the caster will teleport a short distance in that direction.";
    }
}

