/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.google.common.collect.ImmutableList;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.LootUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtract;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class EffectBreak
extends AbstractEffect {
    public EffectBreak() {
        super("break", "Break");
    }

    @Override
    public int getManaCost() {
        return 10;
    }

    public float getHardness(List<AbstractAugment> augments) {
        float maxHardness = 5.0f + (float)(25 * this.getAmplificationBonus(augments));
        int buff = this.getAmplificationBonus(augments);
        if (buff == -1) {
            maxHardness = 2.5f;
        } else if (buff == -2) {
            maxHardness = 1.0f;
        } else if (buff < -2) {
            maxHardness = 0.5f;
        }
        return maxHardness;
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        if (!world.field_72995_K && rayTraceResult instanceof BlockRayTraceResult) {
            BlockPos pos = new BlockPos((Vec3i)((BlockRayTraceResult)rayTraceResult).func_216350_a());
            float maxHardness = this.getHardness(augments);
            int aoeBuff = EffectBreak.getBuffCount(augments, AugmentAOE.class);
            ImmutableList<BlockPos> posList = SpellUtil.calcAOEBlocks(shooter, pos, (BlockRayTraceResult)rayTraceResult, 1 + aoeBuff, 1 + aoeBuff, 1, -1);
            for (BlockPos pos1 : posList) {
                ItemStack stack;
                BlockState state = world.func_180495_p(pos1);
                if (!(state.func_185887_b((IBlockReader)world, pos1) <= maxHardness) || !(state.func_185887_b((IBlockReader)world, pos1) >= 0.0f)) continue;
                if (this.hasBuff(augments, AugmentExtract.class)) {
                    stack = LootUtil.getDefaultFakeTool();
                    stack.func_77966_a(Enchantments.field_185306_r, 1);
                    Block.func_220054_a((BlockState)world.func_180495_p(pos1), (World)world, (BlockPos)pos1, (TileEntity)world.func_175625_s(pos1), (Entity)shooter, (ItemStack)stack);
                    BlockUtil.destroyBlockSafely(world, pos1, false, shooter);
                } else if (this.hasBuff(augments, AugmentFortune.class)) {
                    stack = LootUtil.getDefaultFakeTool();
                    stack.func_77966_a(Enchantments.field_185308_t, EffectBreak.getBuffCount(augments, AugmentFortune.class));
                    Block.func_220054_a((BlockState)world.func_180495_p(pos1), (World)world, (BlockPos)pos1, (TileEntity)world.func_175625_s(pos1), (Entity)shooter, (ItemStack)stack);
                    BlockUtil.destroyBlockSafely(world, pos1, false, shooter);
                } else {
                    BlockUtil.destroyBlockSafely(world, pos1, true, shooter);
                }
                BlockUtil.safelyUpdateState(world, pos);
            }
        }
    }

    @Override
    public boolean wouldSucceed(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments) {
        return rayTraceResult instanceof BlockRayTraceResult && world.func_180495_p(((BlockRayTraceResult)rayTraceResult).func_216350_a()).func_185904_a() != Material.field_151579_a;
    }

    @Override
    public boolean dampenIsAllowed() {
        return true;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_151035_b;
    }

    @Override
    protected String getBookDescription() {
        return "A spell you start with. Breaks blocks of an average hardness. Can be amplified twice to break harder blocks or can break multiple blocks with the AOE augment.";
    }
}

