/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.event.DelayedSpellEvent;
import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EffectDelay
extends AbstractEffect {
    public EffectDelay() {
        super("delay", "Delay");
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        spellContext.setCanceled(true);
        if (spellContext.getCurrentIndex() >= spellContext.recipe.size()) {
            return;
        }
        EventQueue.getInstance().addEvent(new DelayedSpellEvent(10 + EffectDelay.getBuffCount(augments, AugmentExtendTime.class) * 10, spellContext.recipe.subList(spellContext.getCurrentIndex(), spellContext.recipe.size()), rayTraceResult, world, shooter));
    }

    @Override
    public int getManaCost() {
        return 50;
    }

    @Override
    protected String getBookDescription() {
        return "Delays the resolution of effects placed to the right of this spell for a few moments. The delay may be increased with the Extend Time augment.";
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.ONE;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_222027_iT;
    }
}

