/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtract;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class EffectExplosion
extends AbstractEffect {
    public EffectExplosion() {
        super("explosion", "Explosion");
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        if (rayTraceResult == null) {
            return;
        }
        Vec3d vec = rayTraceResult instanceof EntityRayTraceResult ? ((EntityRayTraceResult)rayTraceResult).func_216348_a().func_213303_ch() : rayTraceResult.func_216347_e();
        float intensity = 0.75f + (float)EffectExplosion.getBuffCount(augments, AugmentAmplify.class);
        int dampen = EffectExplosion.getBuffCount(augments, AugmentDampen.class);
        intensity = (float)((double)intensity - 0.5 * (double)dampen);
        Explosion.Mode mode = this.hasBuff(augments, AugmentDampen.class) ? Explosion.Mode.NONE : Explosion.Mode.DESTROY;
        mode = this.hasBuff(augments, AugmentExtract.class) ? Explosion.Mode.BREAK : mode;
        world.func_217385_a((Entity)shooter, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, intensity, mode);
    }

    @Override
    public int getManaCost() {
        return 35;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_221649_bM;
    }

    @Override
    public boolean dampenIsAllowed() {
        return true;
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.TWO;
    }

    @Override
    protected String getBookDescription() {
        return "Causes an explosion at the location.";
    }
}

