/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayerFactory;

public class EffectGrow
extends AbstractEffect {
    public EffectGrow() {
        super("grow", "Grow");
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        if (rayTraceResult instanceof BlockRayTraceResult) {
            for (BlockPos blockpos : SpellUtil.calcAOEBlocks(shooter, ((BlockRayTraceResult)rayTraceResult).func_216350_a(), (BlockRayTraceResult)rayTraceResult, EffectGrow.getBuffCount(augments, AugmentAOE.class))) {
                ItemStack stack = new ItemStack((IItemProvider)Items.field_196106_bc);
                if (!(world instanceof ServerWorld)) continue;
                BoneMealItem.applyBonemeal((ItemStack)stack, (World)world, (BlockPos)blockpos, (PlayerEntity)FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world)));
            }
        }
    }

    @Override
    public boolean wouldSucceed(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments) {
        if (!(rayTraceResult instanceof BlockRayTraceResult)) {
            return false;
        }
        BlockPos pos = ((BlockRayTraceResult)rayTraceResult).func_216350_a();
        return world.func_180495_p(pos) instanceof IGrowable && ((IGrowable)world.func_180495_p(pos)).func_176473_a((IBlockReader)world, pos, world.func_180495_p(pos), world.field_72995_K);
    }

    public static boolean applyBonemeal(World worldIn, BlockPos pos) {
        IGrowable igrowable;
        BlockState blockstate = worldIn.func_180495_p(pos);
        if (blockstate.func_177230_c() instanceof IGrowable && (igrowable = (IGrowable)blockstate.func_177230_c()).func_176473_a((IBlockReader)worldIn, pos, blockstate, worldIn.field_72995_K)) {
            if (!worldIn.field_72995_K && !World.func_189509_E((BlockPos)pos) && igrowable.func_180670_a(worldIn, worldIn.field_73012_v, pos, blockstate)) {
                igrowable.func_225535_a_((ServerWorld)worldIn, worldIn.field_73012_v, pos, blockstate);
                worldIn.func_184138_a(pos, blockstate, blockstate, 3);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getManaCost() {
        return 70;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_221964_gn;
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.TWO;
    }

    @Override
    protected String getBookDescription() {
        return "Causes plants to accelerate in growth, but this does not provide mana for nearby Mana Condensers.";
    }
}

