/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.LootUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootTable;

public class EffectHarm
extends AbstractEffect {
    public EffectHarm() {
        super("harm", "Harm");
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        if (rayTraceResult instanceof EntityRayTraceResult) {
            MobEntity mob;
            float damage = 5.0f + 5.0f * (float)this.getAmplificationBonus(augments);
            Entity entity = ((EntityRayTraceResult)rayTraceResult).func_216348_a();
            if (entity instanceof MobEntity && (mob = (MobEntity)entity).func_110143_aJ() <= damage && mob.func_110143_aJ() > 0.0f && this.hasBuff(augments, AugmentFortune.class)) {
                int looting = EffectHarm.getBuffCount(augments, AugmentFortune.class);
                LootContext.Builder lootContext = LootUtil.getLootingContext((ServerWorld)world, shooter, (LivingEntity)mob, looting, DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)shooter)));
                ResourceLocation lootTable = mob.func_213346_cF();
                LootTable loottable = world.func_73046_m().func_200249_aQ().func_186521_a(lootTable);
                List items = loottable.func_216113_a(lootContext.func_216022_a(LootParameterSets.field_216266_g));
                items.forEach(arg_0 -> ((MobEntity)mob).func_199701_a_(arg_0));
            }
            entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)shooter)), damage);
        }
    }

    @Override
    public boolean wouldSucceed(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments) {
        return rayTraceResult instanceof EntityRayTraceResult;
    }

    @Override
    public boolean dampenIsAllowed() {
        return true;
    }

    @Override
    public int getManaCost() {
        return 20;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_151040_l;
    }

    @Override
    protected String getBookDescription() {
        return "A spell you start with. Damages a target. May be increased by Amplify. Note, multiple Harms without a delay will not apply due to invincibility on hit.";
    }
}

